/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.log;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rescuecore2.config.Config;
import rescuecore2.config.ConfigException;
import rescuecore2.log.CommandsRecord;
import rescuecore2.log.FileLogReader;
import rescuecore2.log.LogException;
import rescuecore2.log.LogReader;
import rescuecore2.log.Logger;
import rescuecore2.log.UpdatesRecord;
import rescuecore2.messages.Command;
import rescuecore2.misc.CommandLineOptions;
import rescuecore2.misc.gui.ListModelList;
import rescuecore2.misc.java.JavaTools;
import rescuecore2.misc.java.LoadableTypeProcessor;
import rescuecore2.registry.Registry;
import rescuecore2.view.EntityInspector;
import rescuecore2.view.RenderedObject;
import rescuecore2.view.ViewComponent;
import rescuecore2.view.ViewListener;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.WorldModel;

public class LogViewer
extends JPanel {
    private static final String VIEWERS_KEY = "log.viewers";
    private static final int TICK_STEP_SIZE = 10;
    private static final int VIEWER_SIZE = 500;
    private static final int FRAME_DELAY = 200;
    private LogReader log;
    private JLabel timestep;
    private EntityInspector inspector;
    private JSlider slider;
    private JList commandsList;
    private JList updatesList;
    private ListModelList<Command> commands;
    private ListModelList<Entity> updates;
    private List<ViewComponent> viewers;
    private JButton down;
    private JButton up;
    private int maxTime;

    public LogViewer(LogReader reader, Config config) throws LogException {
        super(new BorderLayout());
        this.log = reader;
        this.inspector = new EntityInspector();
        this.registerViewers(config);
        this.maxTime = this.log.getMaxTimestep();
        this.slider = new JSlider(0, this.maxTime);
        this.down = new JButton("<-");
        this.up = new JButton("->");
        this.slider.setSnapToTicks(true);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.setMinorTickSpacing(1);
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        ((Dictionary)labels).put(this.maxTime, new JLabel(String.valueOf(this.maxTime)));
        for (int i = 0; i < this.maxTime; i += 10) {
            ((Dictionary)labels).put(i, new JLabel(String.valueOf(i)));
        }
        this.slider.setLabelTable(labels);
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LogViewer.this.showTimestep(LogViewer.this.slider.getValue());
            }
        });
        this.down.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int value = LogViewer.this.slider.getValue() - 1;
                if (value >= 0) {
                    LogViewer.this.slider.setValue(value);
                }
            }
        });
        this.up.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int value = LogViewer.this.slider.getValue() + 1;
                if (value <= LogViewer.this.maxTime) {
                    LogViewer.this.slider.setValue(value);
                }
            }
        });
        final JToggleButton play = new JToggleButton(">>");
        play.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        while (play.isSelected()) {
                            int value = LogViewer.this.slider.getValue() + 1;
                            if (value <= LogViewer.this.maxTime) {
                                LogViewer.this.slider.setValue(value);
                            } else {
                                play.setSelected(false);
                            }
                            try {
                                Thread.sleep(200L);
                            }
                            catch (InterruptedException e1) {
                                Logger.warn("Player interrupted", e1);
                            }
                        }
                    }
                });
                t.start();
            }
        });
        JPanel lists = new JPanel(new GridLayout(0, 1));
        this.commands = new ListModelList();
        this.commandsList = new JList<Command>(this.commands);
        this.updates = new ListModelList();
        this.updatesList = new JList<Entity>(this.updates);
        JScrollPane s = new JScrollPane(this.commandsList);
        s.setBorder(BorderFactory.createTitledBorder("Commands"));
        s.setPreferredSize(this.commandsList.getPreferredScrollableViewportSize());
        lists.add(s);
        s = new JScrollPane(this.updatesList);
        s.setBorder(BorderFactory.createTitledBorder("Updates"));
        s.setPreferredSize(this.updatesList.getPreferredScrollableViewportSize());
        lists.add(s);
        this.timestep = new JLabel("Timestep: 0");
        JTabbedPane tabs = new JTabbedPane();
        for (ViewComponent next : this.viewers) {
            tabs.addTab(next.getViewerName(), next);
            next.addViewListener(new ViewListener(){

                @Override
                public void objectsClicked(ViewComponent view, List<RenderedObject> objects) {
                    for (RenderedObject next : objects) {
                        if (!(next.getObject() instanceof Entity)) continue;
                        LogViewer.this.inspector.inspect((Entity)next.getObject());
                        return;
                    }
                }

                @Override
                public void objectsRollover(ViewComponent view, List<RenderedObject> objects) {
                }
            });
        }
        JSplitPane split1 = new JSplitPane(1, this.inspector, tabs);
        JSplitPane split2 = new JSplitPane(1, split1, lists);
        this.add((Component)split2, "Center");
        Box bottom = Box.createHorizontalBox();
        bottom.add(this.down);
        bottom.add(this.slider);
        bottom.add(this.up);
        bottom.add(play);
        this.add((Component)bottom, "South");
        this.add((Component)this.timestep, "North");
        this.slider.setValue(0);
    }

    public void showTimestep(int time) {
        try {
            if (time < 0 || time > this.maxTime) {
                return;
            }
            this.timestep.setText("Timestep: " + time);
            this.commands.clear();
            this.updates.clear();
            CommandsRecord commandsRecord = this.log.getCommands(time);
            if (commandsRecord != null) {
                this.commands.addAll(commandsRecord.getCommands());
            }
            UpdatesRecord updatesRecord = this.log.getUpdates(time);
            WorldModel<? extends Entity> model = this.log.getWorldModel(time);
            for (ViewComponent next : this.viewers) {
                next.view(model, commandsRecord == null ? null : commandsRecord.getCommands(), updatesRecord == null ? null : updatesRecord.getChangeSet());
                next.repaint();
            }
            this.down.setEnabled(time != 0);
            this.up.setEnabled(time != this.maxTime);
        }
        catch (LogException e) {
            JOptionPane.showMessageDialog(this, e, "Error", 0);
        }
    }

    private void registerViewers(Config config) {
        this.viewers = new ArrayList<ViewComponent>();
        for (String next : config.getArrayValue(VIEWERS_KEY, "")) {
            ViewComponent viewer = JavaTools.instantiate(next, ViewComponent.class);
            if (viewer == null) continue;
            viewer.initialise(config);
            this.viewers.add(viewer);
        }
    }

    public static void main(String[] args) {
        Config config = new Config();
        try {
            args = CommandLineOptions.processArgs(args, config);
            if (args.length != 1) {
                LogViewer.printUsage();
                return;
            }
            String name = args[0];
            LogViewer.processJarFiles(config);
            FileLogReader reader = new FileLogReader(name, Registry.SYSTEM_REGISTRY);
            LogViewer viewer = new LogViewer(reader, config);
            viewer.setPreferredSize(new Dimension(500, 500));
            JFrame frame = new JFrame("Log viewer: " + name);
            frame.getContentPane().add((Component)viewer, "Center");
            frame.pack();
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.setVisible(true);
        }
        catch (IOException e) {
            Logger.error("Error reading log", e);
        }
        catch (ConfigException e) {
            Logger.error("Configuration error", e);
        }
        catch (LogException e) {
            Logger.error("Error reading log", e);
        }
    }

    private static void printUsage() {
        System.out.println("Usage: LogViewer <filename>");
    }

    private static void processJarFiles(Config config) throws IOException {
        LoadableTypeProcessor processor = new LoadableTypeProcessor(config);
        processor.addFactoryRegisterCallbacks(Registry.SYSTEM_REGISTRY);
        processor.process();
    }
}

