/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.connection;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.LinkedList;
import java.util.List;
import rescuecore2.connection.AbstractConnection;
import rescuecore2.connection.Connection;
import rescuecore2.log.Logger;
import rescuecore2.misc.EncodingTools;
import rescuecore2.misc.Pair;
import rescuecore2.misc.WorkerThread;
import rescuecore2.registry.Registry;

public class StreamConnection
extends AbstractConnection {
    private static final int SEND_WAIT = 10000;
    private InputStream in;
    private OutputStream out;
    private ReadThread readThread;
    private WriteThread writeThread;
    private List<byte[]> toWrite;

    public StreamConnection(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        this.toWrite = new LinkedList<byte[]>();
    }

    @Override
    protected void startupImpl() {
        Logger.debug("Starting " + this + ". Registry: " + Registry.getCurrentRegistry());
        this.readThread = new ReadThread();
        this.writeThread = new WriteThread();
        this.readThread.start();
        this.writeThread.start();
    }

    @Override
    public boolean isAlive() {
        return super.isAlive() && this.readThread.isRunning() && this.writeThread.isRunning();
    }

    @Override
    protected void shutdownImpl() {
        Logger.info("Shutting down " + this);
        try {
            this.readThread.kill();
        }
        catch (InterruptedException e) {
            Logger.error("StreamConnection interrupted while shutting down read thread", e);
        }
        try {
            this.writeThread.kill();
        }
        catch (InterruptedException e) {
            Logger.error("StreamConnection interrupted while shutting down write thread", e);
        }
        try {
            this.out.flush();
        }
        catch (IOException e) {
            Logger.error("StreamConnection error flushing output buffer", e);
        }
        try {
            this.out.close();
        }
        catch (IOException e) {
            Logger.error("StreamConnection error closing output buffer", e);
        }
        try {
            this.in.close();
        }
        catch (IOException e) {
            Logger.error("StreamConnection error closing input buffer", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendBytes(byte[] b) throws IOException {
        List<byte[]> list = this.toWrite;
        synchronized (list) {
            this.toWrite.add(b);
            this.toWrite.notifyAll();
        }
    }

    public static Pair<Connection, Connection> createConnectionPair() {
        try {
            PipedInputStream in1 = new PipedInputStream();
            PipedInputStream in2 = new PipedInputStream();
            PipedOutputStream out1 = new PipedOutputStream(in2);
            PipedOutputStream out2 = new PipedOutputStream(in1);
            StreamConnection c1 = new StreamConnection(in1, out1);
            StreamConnection c2 = new StreamConnection(in2, out2);
            return new Pair<Connection, Connection>(c1, c2);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private class WriteThread
    extends WorkerThread {
        private WriteThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean work() throws InterruptedException {
            byte[] bytes = null;
            List list = StreamConnection.this.toWrite;
            synchronized (list) {
                if (StreamConnection.this.toWrite.isEmpty()) {
                    StreamConnection.this.toWrite.wait(10000L);
                    return true;
                }
                bytes = (byte[])StreamConnection.this.toWrite.remove(0);
            }
            if (bytes == null) {
                return true;
            }
            try {
                EncodingTools.writeInt32(bytes.length, StreamConnection.this.out);
                StreamConnection.this.out.write(bytes);
                StreamConnection.this.out.flush();
                return true;
            }
            catch (IOException e) {
                Logger.error("Error writing to StreamConnection " + StreamConnection.this, e);
                return false;
            }
        }
    }

    private class ReadThread
    extends WorkerThread {
        private ReadThread() {
        }

        @Override
        protected boolean work() {
            try {
                int size = EncodingTools.readInt32(StreamConnection.this.in);
                if (size > 0) {
                    byte[] buffer = EncodingTools.readBytes(size, StreamConnection.this.in);
                    StreamConnection.this.bytesReceived(buffer);
                }
                return true;
            }
            catch (InterruptedIOException e) {
                return true;
            }
            catch (EOFException e) {
                return false;
            }
            catch (IOException e) {
                Logger.error("Error reading from StreamConnection " + StreamConnection.this, e);
                return false;
            }
        }
    }
}

