/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.connection;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import rescuecore2.connection.ByteLogger;
import rescuecore2.connection.Connection;
import rescuecore2.connection.ConnectionException;
import rescuecore2.connection.ConnectionListener;
import rescuecore2.log.Logger;
import rescuecore2.messages.Message;
import rescuecore2.misc.EncodingTools;
import rescuecore2.misc.WorkerThread;
import rescuecore2.registry.Registry;

public abstract class AbstractConnection
implements Connection {
    private static final int BROADCAST_WAIT = 10000;
    private List<ConnectionListener> listeners;
    private List<Message> toSend;
    private MessageBroadcastThread broadcast;
    private Registry registry;
    private boolean logBytes = false;
    private String name;
    private volatile State state;
    private final Object stateLock = new Object();

    protected AbstractConnection() {
        this.listeners = new ArrayList<ConnectionListener>();
        this.toSend = new LinkedList<Message>();
        this.state = State.NOT_STARTED;
        this.registry = Registry.SYSTEM_REGISTRY;
        this.name = this.toString();
    }

    @Override
    public void setLogBytes(boolean enabled) {
        this.logBytes = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void startup() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == State.NOT_STARTED) {
                Registry old = Registry.getCurrentRegistry();
                Registry.setCurrentRegistry(this.registry);
                try {
                    this.broadcast = new MessageBroadcastThread();
                    this.broadcast.start();
                    this.startupImpl();
                    this.state = State.STARTED;
                }
                finally {
                    Registry.setCurrentRegistry(old);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void shutdown() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == State.STARTED) {
                try {
                    this.broadcast.kill();
                }
                catch (InterruptedException e) {
                    Logger.error("AbstractConnection interrupted while shutting down broadcast thread", e);
                }
                this.shutdownImpl();
                this.state = State.SHUTDOWN;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAlive() {
        boolean result;
        Object object = this.stateLock;
        synchronized (object) {
            result = this.state == State.STARTED;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionListener(ConnectionListener l) {
        List<ConnectionListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnectionListener(ConnectionListener l) {
        List<ConnectionListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    @Override
    public void sendMessage(Message msg) throws ConnectionException {
        if (msg == null) {
            throw new IllegalArgumentException("Message cannot be null");
        }
        this.sendMessages(Collections.singleton(msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessages(Collection<? extends Message> messages) throws ConnectionException {
        if (messages == null) {
            throw new IllegalArgumentException("Messages cannot be null");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == State.NOT_STARTED) {
                throw new ConnectionException("Connection has not been started");
            }
            if (this.state == State.SHUTDOWN) {
                throw new ConnectionException("Connection has been shut down");
            }
            if (!this.isAlive()) {
                throw new ConnectionException("Connection is dead");
            }
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            for (Message message : messages) {
                EncodingTools.writeMessage(message, out);
            }
            EncodingTools.writeInt32(0, out);
            if (this.logBytes) {
                ByteLogger.log(out.toByteArray());
            }
            this.sendBytes(out.toByteArray());
        }
        catch (IOException e) {
            throw new ConnectionException(e);
        }
    }

    @Override
    public void setRegistry(Registry r) {
        this.registry = r;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    public String toString() {
        if (this.name == null) {
            return super.toString();
        }
        return this.name;
    }

    protected abstract void sendBytes(byte[] var1) throws IOException;

    protected abstract void startupImpl();

    protected abstract void shutdownImpl();

    protected void bytesReceived(byte[] b) {
        ByteArrayInputStream decode = new ByteArrayInputStream(b);
        Message m = null;
        try {
            do {
                if ((m = EncodingTools.readMessage(decode)) == null) continue;
                this.fireMessageReceived(m);
            } while (m != null);
        }
        catch (IOException e) {
            Logger.error("AbstractConnection error reading message", e);
            ByteLogger.log(b, this.toString());
        }
        catch (RuntimeException e) {
            Logger.error("AbstractConnection error reading message", e);
            ByteLogger.log(b, this.toString());
            throw e;
        }
        catch (Error e) {
            Logger.error("AbstractConnection error reading message", e);
            ByteLogger.log(b, this.toString());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireMessageReceived(Message m) {
        List<Message> list = this.toSend;
        synchronized (list) {
            this.toSend.add(m);
            this.toSend.notifyAll();
        }
    }

    private class MessageBroadcastThread
    extends WorkerThread {
        private MessageBroadcastThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean work() throws InterruptedException {
            ConnectionListener[] l;
            Message m = null;
            List list = AbstractConnection.this.toSend;
            synchronized (list) {
                if (AbstractConnection.this.toSend.isEmpty()) {
                    AbstractConnection.this.toSend.wait(10000L);
                    return true;
                }
                m = (Message)AbstractConnection.this.toSend.remove(0);
            }
            if (m == null) {
                return true;
            }
            List list2 = AbstractConnection.this.listeners;
            synchronized (list2) {
                l = new ConnectionListener[AbstractConnection.this.listeners.size()];
                AbstractConnection.this.listeners.toArray(l);
            }
            for (ConnectionListener next : l) {
                next.messageReceived(AbstractConnection.this, m);
            }
            return true;
        }
    }

    protected static enum State {
        NOT_STARTED,
        STARTED,
        SHUTDOWN;

    }
}

