/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.triangulate.quadedge;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Triangle;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.triangulate.quadedge.LastFoundQuadEdgeLocator;
import com.vividsolutions.jts.triangulate.quadedge.LocateFailureException;
import com.vividsolutions.jts.triangulate.quadedge.QuadEdge;
import com.vividsolutions.jts.triangulate.quadedge.QuadEdgeLocator;
import com.vividsolutions.jts.triangulate.quadedge.TriangleVisitor;
import com.vividsolutions.jts.triangulate.quadedge.Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class QuadEdgeSubdivision {
    private static final double EDGE_COINCIDENCE_TOL_FACTOR = 1000.0;
    private int visitedKey = 0;
    private List quadEdges = new ArrayList();
    private QuadEdge startingEdge;
    private double tolerance;
    private double edgeCoincidenceTolerance;
    private Vertex[] frameVertex = new Vertex[3];
    private Envelope frameEnv;
    private QuadEdgeLocator locator = null;
    private LineSegment seg = new LineSegment();
    private QuadEdge[] triEdges = new QuadEdge[3];

    public static void getTriangleEdges(QuadEdge startQE, QuadEdge[] triEdge) {
        triEdge[0] = startQE;
        triEdge[1] = triEdge[0].lNext();
        triEdge[2] = triEdge[1].lNext();
        if (triEdge[2].lNext() != triEdge[0]) {
            throw new IllegalArgumentException("Edges do not form a triangle");
        }
    }

    public QuadEdgeSubdivision(Envelope env, double tolerance) {
        this.tolerance = tolerance;
        this.edgeCoincidenceTolerance = tolerance / 1000.0;
        this.createFrame(env);
        this.startingEdge = this.initSubdiv();
        this.locator = new LastFoundQuadEdgeLocator(this);
    }

    private void createFrame(Envelope env) {
        double deltaX = env.getWidth();
        double deltaY = env.getHeight();
        double offset = 0.0;
        offset = deltaX > deltaY ? deltaX * 10.0 : deltaY * 10.0;
        this.frameVertex[0] = new Vertex((env.getMaxX() + env.getMinX()) / 2.0, env.getMaxY() + offset);
        this.frameVertex[1] = new Vertex(env.getMinX() - offset, env.getMinY() - offset);
        this.frameVertex[2] = new Vertex(env.getMaxX() + offset, env.getMinY() - offset);
        this.frameEnv = new Envelope(this.frameVertex[0].getCoordinate(), this.frameVertex[1].getCoordinate());
        this.frameEnv.expandToInclude(this.frameVertex[2].getCoordinate());
    }

    private QuadEdge initSubdiv() {
        QuadEdge ea = this.makeEdge(this.frameVertex[0], this.frameVertex[1]);
        QuadEdge eb = this.makeEdge(this.frameVertex[1], this.frameVertex[2]);
        QuadEdge.splice(ea.sym(), eb);
        QuadEdge ec = this.makeEdge(this.frameVertex[2], this.frameVertex[0]);
        QuadEdge.splice(eb.sym(), ec);
        QuadEdge.splice(ec.sym(), ea);
        return ea;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public Envelope getEnvelope() {
        return new Envelope(this.frameEnv);
    }

    public Collection getEdges() {
        return this.quadEdges;
    }

    public void setLocator(QuadEdgeLocator locator) {
        this.locator = locator;
    }

    public QuadEdge makeEdge(Vertex o, Vertex d) {
        QuadEdge q = QuadEdge.makeEdge(o, d);
        this.quadEdges.add(q);
        return q;
    }

    public QuadEdge connect(QuadEdge a, QuadEdge b) {
        QuadEdge q = QuadEdge.connect(a, b);
        this.quadEdges.add(q);
        return q;
    }

    public void delete(QuadEdge e) {
        QuadEdge.splice(e, e.oPrev());
        QuadEdge.splice(e.sym(), e.sym().oPrev());
        QuadEdge eSym = e.sym();
        QuadEdge eRot = e.rot();
        QuadEdge eRotSym = e.rot().sym();
        this.quadEdges.remove(e);
        this.quadEdges.remove(eSym);
        this.quadEdges.remove(eRot);
        this.quadEdges.remove(eRotSym);
        e.delete();
        eSym.delete();
        eRot.delete();
        eRotSym.delete();
    }

    public QuadEdge locateFromEdge(Vertex v, QuadEdge startEdge) {
        int iter = 0;
        int maxIter = this.quadEdges.size();
        QuadEdge e = startEdge;
        while (true) {
            if (++iter > maxIter) {
                throw new LocateFailureException(e.toLineSegment());
            }
            if (v.equals(e.orig()) || v.equals(e.dest())) break;
            if (v.rightOf(e)) {
                e = e.sym();
                continue;
            }
            if (!v.rightOf(e.oNext())) {
                e = e.oNext();
                continue;
            }
            if (v.rightOf(e.dPrev())) break;
            e = e.dPrev();
        }
        return e;
    }

    public QuadEdge locate(Vertex v) {
        return this.locator.locate(v);
    }

    public QuadEdge locate(Coordinate p) {
        return this.locator.locate(new Vertex(p));
    }

    public QuadEdge locate(Coordinate p0, Coordinate p1) {
        QuadEdge e = this.locator.locate(new Vertex(p0));
        if (e == null) {
            return null;
        }
        QuadEdge base = e;
        if (e.dest().getCoordinate().equals2D(p0)) {
            base = e.sym();
        }
        QuadEdge locEdge = base;
        do {
            if (!locEdge.dest().getCoordinate().equals2D(p1)) continue;
            return locEdge;
        } while ((locEdge = locEdge.oNext()) != base);
        return null;
    }

    public QuadEdge insertSite(Vertex v) {
        QuadEdge e = this.locate(v);
        if (v.equals(e.orig(), this.tolerance) || v.equals(e.dest(), this.tolerance)) {
            return e;
        }
        QuadEdge base = this.makeEdge(e.orig(), v);
        QuadEdge.splice(base, e);
        QuadEdge startEdge = base;
        while ((e = (base = this.connect(e, base.sym())).oPrev()).lNext() != startEdge) {
        }
        return startEdge;
    }

    public boolean isFrameEdge(QuadEdge e) {
        return this.isFrameVertex(e.orig()) || this.isFrameVertex(e.dest());
    }

    public boolean isFrameBorderEdge(QuadEdge e) {
        QuadEdge[] leftTri = new QuadEdge[3];
        QuadEdgeSubdivision.getTriangleEdges(e, leftTri);
        QuadEdge[] rightTri = new QuadEdge[3];
        QuadEdgeSubdivision.getTriangleEdges(e.sym(), rightTri);
        Vertex vLeftTriOther = e.lNext().dest();
        if (this.isFrameVertex(vLeftTriOther)) {
            return true;
        }
        Vertex vRightTriOther = e.sym().lNext().dest();
        return this.isFrameVertex(vRightTriOther);
    }

    public boolean isFrameVertex(Vertex v) {
        if (v.equals(this.frameVertex[0])) {
            return true;
        }
        if (v.equals(this.frameVertex[1])) {
            return true;
        }
        return v.equals(this.frameVertex[2]);
    }

    public boolean isOnEdge(QuadEdge e, Coordinate p) {
        this.seg.setCoordinates(e.orig().getCoordinate(), e.dest().getCoordinate());
        double dist = this.seg.distance(p);
        return dist < this.edgeCoincidenceTolerance;
    }

    public boolean isVertexOfEdge(QuadEdge e, Vertex v) {
        return v.equals(e.orig(), this.tolerance) || v.equals(e.dest(), this.tolerance);
    }

    public Collection getVertices(boolean includeFrame) {
        HashSet<Vertex> vertices = new HashSet<Vertex>();
        Iterator i = this.quadEdges.iterator();
        while (i.hasNext()) {
            QuadEdge qe = (QuadEdge)i.next();
            Vertex v = qe.orig();
            if (includeFrame || !this.isFrameVertex(v)) {
                vertices.add(v);
            }
            Vertex vd = qe.dest();
            if (!includeFrame && this.isFrameVertex(vd)) continue;
            vertices.add(vd);
        }
        return vertices;
    }

    public List getVertexUniqueEdges(boolean includeFrame) {
        ArrayList<QuadEdge> edges = new ArrayList<QuadEdge>();
        HashSet<Vertex> visitedVertices = new HashSet<Vertex>();
        Iterator i = this.quadEdges.iterator();
        while (i.hasNext()) {
            QuadEdge qd;
            Vertex vd;
            QuadEdge qe = (QuadEdge)i.next();
            Vertex v = qe.orig();
            if (!visitedVertices.contains(v)) {
                visitedVertices.add(v);
                if (includeFrame || !this.isFrameVertex(v)) {
                    edges.add(qe);
                }
            }
            if (visitedVertices.contains(vd = (qd = qe.sym()).orig())) continue;
            visitedVertices.add(vd);
            if (!includeFrame && this.isFrameVertex(vd)) continue;
            edges.add(qd);
        }
        return edges;
    }

    public List getPrimaryEdges(boolean includeFrame) {
        ++this.visitedKey;
        ArrayList<QuadEdge> edges = new ArrayList<QuadEdge>();
        Stack<QuadEdge> edgeStack = new Stack<QuadEdge>();
        edgeStack.push(this.startingEdge);
        HashSet<QuadEdge> visitedEdges = new HashSet<QuadEdge>();
        while (!edgeStack.empty()) {
            QuadEdge edge = (QuadEdge)edgeStack.pop();
            if (visitedEdges.contains(edge)) continue;
            QuadEdge priQE = edge.getPrimary();
            if (includeFrame || !this.isFrameEdge(priQE)) {
                edges.add(priQE);
            }
            edgeStack.push(edge.oNext());
            edgeStack.push(edge.sym().oNext());
            visitedEdges.add(edge);
            visitedEdges.add(edge.sym());
        }
        return edges;
    }

    public void visitTriangles(TriangleVisitor triVisitor, boolean includeFrame) {
        ++this.visitedKey;
        Stack<QuadEdge> edgeStack = new Stack<QuadEdge>();
        edgeStack.push(this.startingEdge);
        HashSet visitedEdges = new HashSet();
        while (!edgeStack.empty()) {
            QuadEdge[] triEdges;
            QuadEdge edge = (QuadEdge)edgeStack.pop();
            if (visitedEdges.contains(edge) || (triEdges = this.fetchTriangleToVisit(edge, edgeStack, includeFrame, visitedEdges)) == null) continue;
            triVisitor.visit(triEdges);
        }
    }

    private QuadEdge[] fetchTriangleToVisit(QuadEdge edge, Stack edgeStack, boolean includeFrame, Set visitedEdges) {
        QuadEdge curr = edge;
        int edgeCount = 0;
        boolean isFrame = false;
        do {
            QuadEdge sym;
            this.triEdges[edgeCount] = curr;
            if (this.isFrameEdge(curr)) {
                isFrame = true;
            }
            if (!visitedEdges.contains(sym = curr.sym())) {
                edgeStack.push(sym);
            }
            visitedEdges.add(curr);
            ++edgeCount;
        } while ((curr = curr.lNext()) != edge);
        if (isFrame && !includeFrame) {
            return null;
        }
        return this.triEdges;
    }

    public List getTriangleEdges(boolean includeFrame) {
        TriangleEdgesListVisitor visitor = new TriangleEdgesListVisitor();
        this.visitTriangles(visitor, includeFrame);
        return visitor.getTriangleEdges();
    }

    public List getTriangleVertices(boolean includeFrame) {
        TriangleVertexListVisitor visitor = new TriangleVertexListVisitor();
        this.visitTriangles(visitor, includeFrame);
        return visitor.getTriangleVertices();
    }

    public List getTriangleCoordinates(boolean includeFrame) {
        TriangleCoordinatesVisitor visitor = new TriangleCoordinatesVisitor();
        this.visitTriangles(visitor, includeFrame);
        return visitor.getTriangles();
    }

    public Geometry getEdges(GeometryFactory geomFact) {
        List quadEdges = this.getPrimaryEdges(false);
        LineString[] edges = new LineString[quadEdges.size()];
        int i = 0;
        Iterator it = quadEdges.iterator();
        while (it.hasNext()) {
            QuadEdge qe = (QuadEdge)it.next();
            edges[i++] = geomFact.createLineString(new Coordinate[]{qe.orig().getCoordinate(), qe.dest().getCoordinate()});
        }
        return geomFact.createMultiLineString(edges);
    }

    public Geometry getTriangles(GeometryFactory geomFact) {
        List triPtsList = this.getTriangleCoordinates(false);
        Geometry[] tris = new Polygon[triPtsList.size()];
        int i = 0;
        Iterator it = triPtsList.iterator();
        while (it.hasNext()) {
            Coordinate[] triPt = (Coordinate[])it.next();
            tris[i++] = geomFact.createPolygon(geomFact.createLinearRing(triPt), null);
        }
        return geomFact.createGeometryCollection(tris);
    }

    public Geometry getVoronoiDiagram(GeometryFactory geomFact) {
        List vorCells = this.getVoronoiCellPolygons(geomFact);
        return geomFact.createGeometryCollection(GeometryFactory.toGeometryArray(vorCells));
    }

    public List getVoronoiCellPolygons(GeometryFactory geomFact) {
        this.visitTriangles(new TriangleCircumcentreVisitor(), true);
        ArrayList<Polygon> cells = new ArrayList<Polygon>();
        List edges = this.getVertexUniqueEdges(false);
        Iterator i = edges.iterator();
        while (i.hasNext()) {
            QuadEdge qe = (QuadEdge)i.next();
            cells.add(this.getVoronoiCellPolygon(qe, geomFact));
        }
        return cells;
    }

    public Polygon getVoronoiCellPolygon(QuadEdge qe, GeometryFactory geomFact) {
        ArrayList<Coordinate> cellPts = new ArrayList<Coordinate>();
        QuadEdge startQE = qe;
        do {
            Coordinate cc = qe.rot().orig().getCoordinate();
            cellPts.add(cc);
        } while ((qe = qe.oPrev()) != startQE);
        CoordinateList coordList = new CoordinateList();
        coordList.addAll(cellPts, false);
        coordList.closeRing();
        Coordinate[] pts = coordList.toCoordinateArray();
        Polygon cellPoly = geomFact.createPolygon(geomFact.createLinearRing(pts), null);
        Vertex v = startQE.orig();
        cellPoly.setUserData(v.getCoordinate());
        return cellPoly;
    }

    private static class TriangleCoordinatesVisitor
    implements TriangleVisitor {
        private CoordinateList coordList = new CoordinateList();
        private List triCoords = new ArrayList();

        public void visit(QuadEdge[] triEdges) {
            this.coordList.clear();
            for (int i = 0; i < 3; ++i) {
                Vertex v = triEdges[i].orig();
                this.coordList.add(v.getCoordinate());
            }
            if (this.coordList.size() > 0) {
                this.coordList.closeRing();
                Coordinate[] pts = this.coordList.toCoordinateArray();
                if (pts.length != 4) {
                    String loc = "";
                    if (pts.length >= 2) {
                        loc = WKTWriter.toLineString(pts[0], pts[1]);
                    } else if (pts.length >= 1) {
                        loc = WKTWriter.toPoint(pts[0]);
                    }
                    return;
                }
                this.triCoords.add(pts);
            }
        }

        public List getTriangles() {
            return this.triCoords;
        }
    }

    private static class TriangleVertexListVisitor
    implements TriangleVisitor {
        private List triList = new ArrayList();

        private TriangleVertexListVisitor() {
        }

        public void visit(QuadEdge[] triEdges) {
            this.triList.add(new Vertex[]{triEdges[0].orig(), triEdges[1].orig(), triEdges[2].orig()});
        }

        public List getTriangleVertices() {
            return this.triList;
        }
    }

    private static class TriangleEdgesListVisitor
    implements TriangleVisitor {
        private List triList = new ArrayList();

        private TriangleEdgesListVisitor() {
        }

        public void visit(QuadEdge[] triEdges) {
            this.triList.add(triEdges.clone());
        }

        public List getTriangleEdges() {
            return this.triList;
        }
    }

    private static class TriangleCircumcentreVisitor
    implements TriangleVisitor {
        public void visit(QuadEdge[] triEdges) {
            Coordinate a = triEdges[0].orig().getCoordinate();
            Coordinate b = triEdges[1].orig().getCoordinate();
            Coordinate c = triEdges[2].orig().getCoordinate();
            Coordinate cc = Triangle.circumcentre(a, b, c);
            Vertex ccVertex = new Vertex(cc);
            for (int i = 0; i < 3; ++i) {
                triEdges[i].rot().setOrig(ccVertex);
            }
        }
    }
}

