/*
 * Decompiled with CFR 0.152.
 */
package kernel.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import kernel.ui.ScoreGraph;
import rescuecore2.GUIComponent;
import rescuecore2.Timestep;
import rescuecore2.config.Config;
import rescuecore2.score.CompositeScoreFunction;
import rescuecore2.score.DelegatingScoreFunction;
import rescuecore2.score.ScoreFunction;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.WorldModel;

public class ScoreTable
extends DelegatingScoreFunction
implements GUIComponent {
    private ScoreModel model;

    public ScoreTable(ScoreFunction child) {
        super("Score Table", child);
    }

    public void initialise(WorldModel<? extends Entity> world, Config config) {
        super.initialise(world, config);
        this.model = new ScoreModel(this.child);
    }

    public double score(WorldModel<? extends Entity> world, Timestep timestep) {
        this.model.update(world, timestep);
        return super.score(world, timestep);
    }

    public JComponent getGUIComponent() {
        JTable table = new JTable(this.model.table);
        table.setAutoResizeMode(0);
        JScrollPane scroll = new JScrollPane(table);
        JList rowHeader = new JList(this.model.list);
        rowHeader.setFixedCellHeight(table.getRowHeight());
        rowHeader.setCellRenderer(new RowHeaderRenderer(table));
        rowHeader.setBackground(table.getBackground());
        rowHeader.setOpaque(true);
        scroll.setRowHeaderView(rowHeader);
        return scroll;
    }

    public String getGUIComponentName() {
        return "Score";
    }

    private static class ScoreModel {
        ScoreTableModel table;
        ScoreListModel list;
        private int steps = 0;
        private List<ScoreFunctionEntry> entries = new ArrayList<ScoreFunctionEntry>();

        ScoreModel(ScoreFunction root) {
            this.populateEntries(root, "");
            this.table = new ScoreTableModel();
            this.list = new ScoreListModel();
        }

        private void populateEntries(ScoreFunction root, String prefix) {
            String suffix = "";
            if (!(root instanceof ScoreTable) && !(root instanceof ScoreGraph)) {
                this.entries.add(new ScoreFunctionEntry(root, prefix));
                suffix = "--";
            }
            if (root instanceof DelegatingScoreFunction) {
                this.populateEntries(((DelegatingScoreFunction)root).getChildFunction(), prefix + suffix);
            }
            if (root instanceof CompositeScoreFunction) {
                Set children = ((CompositeScoreFunction)root).getChildFunctions();
                for (ScoreFunction next : children) {
                    this.populateEntries(next, prefix + suffix);
                }
            }
        }

        void update(WorldModel<? extends Entity> world, Timestep timestep) {
            for (ScoreFunctionEntry next : this.entries) {
                next.update(world, timestep);
            }
            this.steps = timestep.getTime();
            this.table.fireTableStructureChanged();
        }

        private static class ScoreFunctionEntry {
            private ScoreFunction function;
            private String prefix;
            private Map<Integer, Double> scores;

            public ScoreFunctionEntry(ScoreFunction f, String prefix) {
                this.function = f;
                this.prefix = prefix;
                this.scores = new HashMap<Integer, Double>();
            }

            public String getScoreFunctionName() {
                return this.prefix + this.function.getName();
            }

            public double getScore(int step) {
                return this.scores.containsKey(step) ? this.scores.get(step) : Double.NaN;
            }

            void update(WorldModel<? extends Entity> world, Timestep timestep) {
                double d = this.function.score(world, timestep);
                this.scores.put(timestep.getTime(), d);
            }
        }

        private class ScoreListModel
        extends AbstractListModel {
            private ScoreListModel() {
            }

            @Override
            public int getSize() {
                return ScoreModel.this.entries.size();
            }

            @Override
            public Object getElementAt(int row) {
                return ((ScoreFunctionEntry)ScoreModel.this.entries.get(row)).getScoreFunctionName();
            }
        }

        private class ScoreTableModel
        extends AbstractTableModel {
            private ScoreTableModel() {
            }

            @Override
            public String getColumnName(int col) {
                return String.valueOf(col + 1);
            }

            @Override
            public int getRowCount() {
                return ScoreModel.this.entries.size();
            }

            @Override
            public int getColumnCount() {
                return ScoreModel.this.steps;
            }

            @Override
            public Object getValueAt(int row, int column) {
                return ((ScoreFunctionEntry)ScoreModel.this.entries.get(row)).getScore(column + 1);
            }
        }
    }

    private static class RowHeaderRenderer
    extends JLabel
    implements ListCellRenderer {
        RowHeaderRenderer(JTable table) {
            JTableHeader header = table.getTableHeader();
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(2);
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }

        public JLabel getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

