/*
 * Decompiled with CFR 0.152.
 */
package kernel.ui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kernel.ui.ScoreTable;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import rescuecore2.GUIComponent;
import rescuecore2.Timestep;
import rescuecore2.config.Config;
import rescuecore2.score.CompositeScoreFunction;
import rescuecore2.score.DelegatingScoreFunction;
import rescuecore2.score.ScoreFunction;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.WorldModel;

public class ScoreGraph
extends DelegatingScoreFunction
implements GUIComponent {
    private JFreeChart chart;
    private List<SeriesInfo> allSeries;

    public ScoreGraph(ScoreFunction child) {
        super("Score graph", child);
    }

    public void initialise(WorldModel<? extends Entity> world, Config config) {
        super.initialise(world, config);
        this.allSeries = new ArrayList<SeriesInfo>();
        XYSeriesCollection data = new XYSeriesCollection();
        this.createSeries(this.child, data);
        PlotOrientation orientation = PlotOrientation.VERTICAL;
        this.chart = ChartFactory.createXYLineChart((String)"Score", (String)"Time", (String)"Score", (XYDataset)data, (PlotOrientation)orientation, (boolean)true, (boolean)false, (boolean)false);
    }

    public double score(WorldModel<? extends Entity> world, Timestep timestep) {
        this.update(world, timestep);
        return super.score(world, timestep);
    }

    public JComponent getGUIComponent() {
        Box selectionPanel = Box.createVerticalBox();
        final XYItemRenderer renderer = ((XYPlot)this.chart.getPlot()).getRenderer();
        for (SeriesInfo next : this.allSeries) {
            ScoreFunction f = next.function;
            final int index = next.index;
            final JCheckBox checkBox = new JCheckBox(f.getName(), true);
            selectionPanel.add(checkBox);
            checkBox.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    boolean selected = checkBox.isSelected();
                    renderer.setSeriesVisible(index, Boolean.valueOf(selected));
                }
            });
        }
        JPanel result = new JPanel();
        result.add((Component)new ChartPanel(this.chart), "Center");
        result.add((Component)selectionPanel, "East");
        return result;
    }

    public String getGUIComponentName() {
        return "Score chart";
    }

    private void createSeries(ScoreFunction root, XYSeriesCollection data) {
        if (!(root instanceof ScoreTable) && !(root instanceof ScoreGraph)) {
            XYSeries next = new XYSeries((Comparable)((Object)root.getName()));
            this.allSeries.add(new SeriesInfo(root, next, this.allSeries.size()));
            data.addSeries(next);
        }
        if (root instanceof DelegatingScoreFunction) {
            this.createSeries(((DelegatingScoreFunction)root).getChildFunction(), data);
        }
        if (root instanceof CompositeScoreFunction) {
            Set children = ((CompositeScoreFunction)root).getChildFunctions();
            for (ScoreFunction f : children) {
                this.createSeries(f, data);
            }
        }
    }

    private void update(WorldModel<? extends Entity> world, Timestep timestep) {
        for (SeriesInfo next : this.allSeries) {
            ScoreFunction f = next.function;
            XYSeries data = next.series;
            double d = f.score(world, timestep);
            data.add((double)timestep.getTime(), d);
        }
    }

    private static class SeriesInfo {
        ScoreFunction function;
        XYSeries series;
        int index;

        public SeriesInfo(ScoreFunction function, XYSeries series, int index) {
            this.function = function;
            this.series = series;
            this.index = index;
        }
    }
}

