/*
 * Decompiled with CFR 0.152.
 */
package kernel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kernel.AbstractKernelComponent;
import kernel.EntityIDGenerator;
import rescuecore2.connection.Connection;
import rescuecore2.connection.ConnectionListener;
import rescuecore2.log.Logger;
import rescuecore2.messages.Command;
import rescuecore2.messages.Message;
import rescuecore2.messages.control.EntityIDRequest;
import rescuecore2.messages.control.EntityIDResponse;
import rescuecore2.messages.control.KSCommands;
import rescuecore2.messages.control.KSUpdate;
import rescuecore2.messages.control.SKUpdate;
import rescuecore2.worldmodel.ChangeSet;
import rescuecore2.worldmodel.EntityID;

public class SimulatorProxy
extends AbstractKernelComponent {
    private Map<Integer, ChangeSet> updates;
    private int id;
    private EntityIDGenerator idGenerator;

    public SimulatorProxy(String name, int id, Connection c) {
        super(name, c);
        this.id = id;
        this.updates = new HashMap<Integer, ChangeSet>();
        c.addConnectionListener((ConnectionListener)new SimulatorConnectionListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeSet getUpdates(int time) throws InterruptedException {
        ChangeSet result = null;
        Map<Integer, ChangeSet> map = this.updates;
        synchronized (map) {
            while (result == null) {
                result = this.updates.get(time);
                if (result != null) continue;
                this.updates.wait(1000L);
            }
        }
        return result;
    }

    public void sendUpdate(int time, ChangeSet update) {
        this.send((Message)new KSUpdate(this.id, time, update));
    }

    public void sendAgentCommands(int time, Collection<? extends Command> commands) {
        this.send((Message)new KSCommands(this.id, time, commands));
    }

    public String toString() {
        return this.getName() + " (" + this.id + "): " + this.getConnection().toString();
    }

    public void setEntityIDGenerator(EntityIDGenerator generator) {
        this.idGenerator = generator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateReceived(int time, ChangeSet changes) {
        Map<Integer, ChangeSet> map = this.updates;
        synchronized (map) {
            ChangeSet c = this.updates.get(time);
            if (c == null) {
                c = new ChangeSet();
                this.updates.put(time, c);
            }
            c.merge(changes);
            this.updates.notifyAll();
        }
    }

    private class SimulatorConnectionListener
    implements ConnectionListener {
        private SimulatorConnectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageReceived(Connection connection, Message msg) {
            Logger.pushLogContext((String)"kernel");
            try {
                SKUpdate update;
                if (msg instanceof SKUpdate && (update = (SKUpdate)msg).getSimulatorID() == SimulatorProxy.this.id) {
                    SimulatorProxy.this.updateReceived(update.getTime(), update.getChangeSet());
                }
                if (msg instanceof EntityIDRequest) {
                    EntityIDRequest req = (EntityIDRequest)msg;
                    Logger.debug((String)("Simulator proxy " + SimulatorProxy.this.id + " received entity ID request: " + msg));
                    if (req.getSimulatorID() == SimulatorProxy.this.id) {
                        int requestID = req.getRequestID();
                        int count = req.getCount();
                        ArrayList<EntityID> result = new ArrayList<EntityID>(count);
                        for (int i = 0; i < count; ++i) {
                            result.add(SimulatorProxy.this.idGenerator.generateID());
                        }
                        Logger.debug((String)("Simulator proxy " + SimulatorProxy.this.id + " sending new IDs: " + result));
                        SimulatorProxy.this.send((Message)new EntityIDResponse(SimulatorProxy.this.id, requestID, result));
                    }
                }
            }
            finally {
                Logger.popLogContext();
            }
        }
    }
}

