/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;

public class RenderTools {
    private static final int HATCH_SIZE = 9;
    private static final Stroke SOLID_STROKE = new BasicStroke(1.0f);
    private static final float[] DOT_PATTERN = new float[]{0.1f, 1.0f};
    private static final float[] DASH_PATTERN = new float[]{1.0f, 1.0f};
    private static final float[] DOT_DASH_PATTERN = new float[]{0.1f, 1.0f, 1.0f, 1.0f};
    private static final float[][] DASH_PATTERNS = new float[][]{null, DOT_PATTERN, DASH_PATTERN, DOT_DASH_PATTERN};
    private static final BufferedImage HORIZONTAL = new BufferedImage(9, 9, 2);
    private static final BufferedImage VERTICAL = new BufferedImage(9, 9, 2);
    private static final BufferedImage DIAGONAL = new BufferedImage(9, 9, 2);
    private static final BufferedImage REVERSE_DIAGONAL = new BufferedImage(9, 9, 2);
    private static final BufferedImage HATCH = new BufferedImage(9, 9, 2);
    private static final BufferedImage CROSS_HATCH = new BufferedImage(9, 9, 2);
    private static final Rectangle ANCHOR = new Rectangle(0, 0, 9, 9);
    private static final int TRANSPARENT_BLACK = new Color(0, 0, 0, 0).getRGB();

    private RenderTools() {
    }

    public static void setLineMode(Graphics g, int mode, Color colour, int width) {
        Stroke stroke = mode == 0 ? (width == 1 ? SOLID_STROKE : new BasicStroke(width)) : new BasicStroke(width, 0, 0, 1.0f, DASH_PATTERNS[mode], 0.0f);
        ((Graphics2D)g).setStroke(stroke);
        if (colour != null) {
            g.setColor(colour);
        }
    }

    public static void setLineMode(Graphics g, int mode, Color colour) {
        RenderTools.setLineMode(g, mode, colour, 1);
    }

    public static void setLineMode(Graphics g, int mode) {
        RenderTools.setLineMode(g, mode, null, 1);
    }

    public static void setLineMode(Graphics g, int mode, int width) {
        RenderTools.setLineMode(g, mode, null, width);
    }

    public static void setFillMode(Graphics g, int mode, Color colour) {
        int c = colour.getRGB();
        for (int x = 0; x < 9; ++x) {
            HORIZONTAL.setRGB(x, 4, c);
            VERTICAL.setRGB(4, x, c);
            DIAGONAL.setRGB(x, x, c);
            REVERSE_DIAGONAL.setRGB(9 - x - 1, x, c);
            HATCH.setRGB(x, 4, c);
            HATCH.setRGB(4, x, c);
            CROSS_HATCH.setRGB(x, x, c);
            CROSS_HATCH.setRGB(9 - x - 1, x, c);
        }
        switch (mode) {
            case 0: {
                ((Graphics2D)g).setPaint(colour);
                break;
            }
            case 1: {
                ((Graphics2D)g).setPaint(new TexturePaint(HORIZONTAL, ANCHOR));
                break;
            }
            case 2: {
                ((Graphics2D)g).setPaint(new TexturePaint(VERTICAL, ANCHOR));
                break;
            }
            case 3: {
                ((Graphics2D)g).setPaint(new TexturePaint(DIAGONAL, ANCHOR));
                break;
            }
            case 4: {
                ((Graphics2D)g).setPaint(new TexturePaint(REVERSE_DIAGONAL, ANCHOR));
                break;
            }
            case 5: {
                ((Graphics2D)g).setPaint(new TexturePaint(HATCH, ANCHOR));
                break;
            }
            case 6: {
                ((Graphics2D)g).setPaint(new TexturePaint(CROSS_HATCH, ANCHOR));
            }
        }
    }

    static {
        for (int x = 0; x < 9; ++x) {
            for (int y = 0; y < 9; ++y) {
                HORIZONTAL.setRGB(x, y, TRANSPARENT_BLACK);
                VERTICAL.setRGB(x, y, TRANSPARENT_BLACK);
                DIAGONAL.setRGB(x, y, TRANSPARENT_BLACK);
                REVERSE_DIAGONAL.setRGB(x, y, TRANSPARENT_BLACK);
                HATCH.setRGB(x, y, TRANSPARENT_BLACK);
                CROSS_HATCH.setRGB(x, y, TRANSPARENT_BLACK);
            }
        }
    }
}

