/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.tools.simulationrunner;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import rescuecore.tools.simulationrunner.ProcessHandler;
import rescuecore.tools.simulationrunner.RescueProcess;
import rescuecore.tools.simulationrunner.SimulationConstants;

public class SimulationClient
implements SimulationConstants {
    private ProcessHandler processHandler;
    private InputHandler input;

    public static void main(String[] args) {
        int port = 12536;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("--help")) {
                SimulationClient.printHelp();
                return;
            }
            if (!args[i].equalsIgnoreCase("-p") && !args[i].equalsIgnoreCase("--port")) continue;
            port = Integer.parseInt(args[++i]);
        }
        try {
            new SimulationClient(port);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void printHelp() {
        System.out.println("Usage: SimulationClient [-p | --port <port number>]");
        System.out.println("-p\t--port\tListen on <port number>. Default 12536");
    }

    public SimulationClient(int port) throws IOException {
        this.input = new InputHandler(port);
        new Thread(this.input).start();
    }

    private void kill() {
        this.input.kill();
    }

    private synchronized boolean runProcesses(RescueProcess[] processes) {
        if (this.processHandler != null) {
            return false;
        }
        this.processHandler = new ProcessHandler(processes, null);
        new Thread(){

            @Override
            public void run() {
                SimulationClient.this.processHandler.runAll();
                SimulationClient.this.stopProcesses();
            }
        }.start();
        return true;
    }

    private synchronized void stopProcesses() {
        if (this.processHandler == null) {
            return;
        }
        this.processHandler.stopAll();
        this.processHandler = null;
    }

    private class InputHandler
    implements Runnable {
        private volatile boolean alive;
        private volatile boolean running;
        private ServerSocket server;

        public InputHandler(int port) throws IOException {
            this.server = new ServerSocket(port);
            this.server.setSoTimeout(1000);
            this.alive = true;
            this.running = true;
        }

        public synchronized void kill() {
            this.running = false;
            while (this.alive) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (this.running) {
                    Socket s = this.server.accept();
                    this.handle(s);
                    s.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.server.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            InputHandler inputHandler = this;
            synchronized (inputHandler) {
                this.alive = false;
                this.notifyAll();
            }
        }

        private void handle(Socket s) throws IOException {
            FilterInputStream in = null;
            DataOutputStream out = null;
            try {
                int command;
                out = new DataOutputStream(new BufferedOutputStream(s.getOutputStream()));
                in = new DataInputStream(new BufferedInputStream(s.getInputStream()));
                do {
                    command = ((DataInputStream)in).readInt();
                    switch (command) {
                        case 0: {
                            SimulationClient.this.stopProcesses();
                            out.writeInt(-2);
                            break;
                        }
                        case 1: {
                            if (this.handleStart((DataInputStream)in)) {
                                out.writeInt(-2);
                                break;
                            }
                            out.writeInt(-3);
                            break;
                        }
                        case 2: {
                            if (this.handleFile((DataInputStream)in, out)) {
                                out.writeInt(-2);
                                break;
                            }
                            out.writeInt(-3);
                            break;
                        }
                        case 3: {
                            out.writeInt(-2);
                            break;
                        }
                        default: {
                            System.err.println("Unrecognised command: " + command);
                            out.writeInt(-1);
                        }
                    }
                    out.flush();
                } while (command != 3);
            }
            catch (IOException e) {
                out.writeInt(-3);
                throw e;
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    try {
                        out.flush();
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        private boolean handleStart(DataInputStream in) throws IOException {
            int num = in.readInt();
            RescueProcess[] processes = new RescueProcess[num];
            for (int i = 0; i < num; ++i) {
                processes[i] = new RescueProcess(in.readUTF(), in.readUTF(), in.readUTF(), null);
            }
            return SimulationClient.this.runProcesses(processes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean handleFile(DataInputStream in, DataOutputStream out) throws IOException {
            String name = in.readUTF();
            long size = in.readLong();
            OutputStream file = null;
            try {
                try {
                    file = new BufferedOutputStream(new FileOutputStream(name));
                }
                catch (IOException e) {
                    boolean bl = false;
                    if (file != null) {
                        try {
                            file.flush();
                            file.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                    }
                    return bl;
                }
                byte[] buffer = new byte[1024];
                long count = 0L;
                while (count < size) {
                    int num = in.read(buffer);
                    if (num <= 0) continue;
                    try {
                        file.write(buffer, 0, num);
                        count += (long)num;
                    }
                    catch (IOException e) {
                        boolean bl = false;
                        if (file != null) {
                            try {
                                file.flush();
                                file.close();
                            }
                            catch (IOException e3) {
                                // empty catch block
                            }
                        }
                        return bl;
                    }
                }
            }
            finally {
                if (file != null) {
                    try {
                        file.flush();
                        file.close();
                    }
                    catch (IOException e) {}
                }
            }
            return true;
        }
    }
}

