/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.tools.simulationrunner;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rescuecore.tools.simulationrunner.RescueProcess;

public class ConfigFile {
    private Map variables = new HashMap();
    private List processes = new ArrayList();

    public ConfigFile(String fileName, String logPrefix) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(new File(fileName)));
        String next = null;
        do {
            if ((next = in.readLine()) == null || (next = next.trim()).startsWith("#") || next.equals("")) continue;
            if ((next = this.substituteVariables(next)).indexOf("=") == -1) {
                this.addProcess(next, logPrefix);
                continue;
            }
            this.addVariable(next);
        } while (next != null);
    }

    public List getProcesses() {
        return this.processes;
    }

    private void addProcess(String line, String logPrefix) {
        int index1 = line.indexOf("#");
        int index2 = line.indexOf("#", index1 + 1);
        String name = line.substring(0, index1);
        String command = line.substring(index1 + 1, index2);
        String rexp = line.substring(index2 + 1);
        RescueProcess p = new RescueProcess(name, command, rexp, logPrefix);
        this.processes.add(p);
    }

    private void addVariable(String line) {
        int index = line.indexOf("=");
        String name = line.substring(0, index);
        String value = line.substring(index + 1);
        this.variables.put(name, value);
    }

    private String substituteVariables(String original) {
        int start = 0;
        int end = 0;
        StringBuffer result = new StringBuffer(original);
        do {
            String current = result.toString();
            start = current.indexOf("${");
            end = current.indexOf("}", start);
            if (start <= 0 || end <= 0) continue;
            String name = current.substring(start + 2, end);
            String value = (String)this.variables.get(name);
            if (value == null) {
                value = System.getProperty(name);
            }
            if (value == null) {
                value = "";
            }
            result.replace(start, end + 1, value);
        } while (start > 0 && end > 0);
        return result.toString();
    }
}

