/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.tools.mapgenerator;

import java.io.IOException;
import java.util.Random;
import rescuecore.tools.mapgenerator.AntsRoadWeighter;
import rescuecore.tools.mapgenerator.BasicBuildingGenerator;
import rescuecore.tools.mapgenerator.RescueMap;
import rescuecore.tools.mapgenerator.RescueMapToolkit;
import rescuecore.tools.mapgenerator.RoadSetFactory;

public class MapGenerator {
    public static RescueMap generateMap(boolean rotate, boolean nooneway, int roadDensity, int roadRemoval, int buildDensity, int width, int height, int uniformity, int movement, int smooth, String initScheme, String connScheme, String buildScheme, long seed) {
        Random rand = new Random(seed);
        RescueMap rm = RoadSetFactory.createRoadSet(initScheme, width, height, roadDensity, rand);
        RescueMapToolkit.randomise(rm, uniformity, roadDensity, roadRemoval, movement, nooneway, rand);
        if (rotate) {
            RescueMapToolkit.rotate(rm, rand.nextDouble() * Math.PI * 2.0);
        }
        RescueMapToolkit.findIntersections(rm);
        MapGenerator.weightRoads(rm, uniformity, connScheme, nooneway, rand);
        RescueMapToolkit.smoothRoads(rm, smooth);
        MapGenerator.addBuildings(rm, uniformity, buildDensity, buildScheme, rand);
        rm.align();
        System.out.println("Construction complete.");
        return rm;
    }

    private static void weightRoads(RescueMap rm, int uniformity, String connScheme, boolean nooneway, Random rand) {
        if (!connScheme.equals("ants")) {
            return;
        }
        AntsRoadWeighter rw = new AntsRoadWeighter();
        rw.connect(rm, uniformity, nooneway, rand);
    }

    private static void addBuildings(RescueMap rm, int uniformity, int buildDensity, String buildScheme, Random rand) {
        if (!buildScheme.equals("blocks")) {
            return;
        }
        BasicBuildingGenerator bg = new BasicBuildingGenerator();
        bg.addBuildings(rm, uniformity, buildDensity, rand);
    }

    public static void main(String[] args) {
        int roadDensity = 60;
        int roadRemoval = 15;
        int buildDensity = 50;
        int width = 1000000;
        int height = 1000000;
        int uniformity = 75;
        int movement = 20;
        int smooth = 5;
        boolean rotate = false;
        boolean nooneway = false;
        String initScheme = "grid";
        String connScheme = "none";
        String buildScheme = "blocks";
        long seed = System.currentTimeMillis();
        for (int i = 0; i < args.length; i += 2) {
            if (args[i].equals("-rd")) {
                roadDensity = Integer.parseInt(args[i + 1]);
                continue;
            }
            if (args[i].equals("-rr")) {
                roadRemoval = Integer.parseInt(args[i + 1]);
                continue;
            }
            if (args[i].equals("-bd")) {
                buildDensity = Integer.parseInt(args[i + 1]);
                continue;
            }
            if (args[i].equals("-w")) {
                width = Integer.parseInt(args[i + 1]);
                continue;
            }
            if (args[i].equals("-h")) {
                height = Integer.parseInt(args[i + 1]);
                continue;
            }
            if (args[i].equals("-u")) {
                uniformity = Integer.parseInt(args[i + 1]);
                continue;
            }
            if (args[i].equals("-m")) {
                movement = Integer.parseInt(args[i + 1]);
                continue;
            }
            if (args[i].equals("-sm")) {
                smooth = Integer.parseInt(args[i + 1]);
                continue;
            }
            if (args[i].equals("-init")) {
                initScheme = args[i + 1];
                continue;
            }
            if (args[i].equals("-weight")) {
                connScheme = args[i + 1];
                continue;
            }
            if (args[i].equals("-build")) {
                buildScheme = args[i + 1];
                continue;
            }
            if (args[i].equals("-r")) {
                seed = Long.parseLong(args[i + 1]);
                continue;
            }
            if (args[i].equals("-rotate")) {
                rotate = true;
                --i;
                continue;
            }
            if (args[i].equals("-nooneway")) {
                nooneway = true;
                --i;
                continue;
            }
            System.out.println("Switches: [-switch] [valid range] [default] [description]");
            System.out.println("-rd [0..100] 60 \t\tRoad density");
            System.out.println("-rr [5..90] 15 \t\tRoad removal percentage");
            System.out.println("-bd [0..100] 50 \t\tBuilding density");
            System.out.println("-u [0..100] 75 \t\t\tRoad uniformity");
            System.out.println("-w [0..*] 1000000 \t\tMap width (millimeters)");
            System.out.println("-h [0..*] 1000000 \t\tMap height (millimeters)");
            System.out.println("-m [0..*] 20 \t\t\tMax node movement (meters)");
            System.out.println("-sm [1..8] 5 \t\t\tSmooth wide roads (lanes)");
            System.out.println("-init [grid] grid \t\tMap initialisation scheme");
            System.out.println("-weight [none,ants] none \tRoad weighting scheme");
            System.out.println("-build [blocks] \t\tblocks Building scheme");
            System.out.println("-rotate \t\t\tSet random map rotation flag");
            System.out.println("-nooneway \t\t\tSwitch off one way streets");
            return;
        }
        RescueMap m = MapGenerator.generateMap(rotate, nooneway, roadDensity, roadRemoval, buildDensity, width, height, uniformity, movement, smooth, initScheme, connScheme, buildScheme, seed);
        try {
            m.toFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

