/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.sample;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import rescuecore.CannotFindLocationException;
import rescuecore.Memory;
import rescuecore.RescueObject;

public class SampleSearch {
    private static final DistanceSorter DISTANCE_SORTER = new DistanceSorter();

    public static int[] breadthFirstSearch(RescueObject start, RescueObject goal, Memory memory) {
        LinkedList<RescueObject> open = new LinkedList<RescueObject>();
        HashMap<RescueObject, RescueObject> ancestors = new HashMap<RescueObject, RescueObject>();
        open.add(start);
        RescueObject next = null;
        block0: do {
            RescueObject[] neighbours;
            if ((neighbours = memory.findNeighbours(next = (RescueObject)open.remove(0))) == null) continue;
            for (int i = 0; i < neighbours.length; ++i) {
                if (neighbours[i] == null) continue;
                if (neighbours[i] == goal) {
                    ancestors.put(neighbours[i], next);
                    next = neighbours[i];
                    continue block0;
                }
                if (ancestors.containsKey(neighbours[i]) || neighbours[i].isBuilding()) continue;
                open.add(neighbours[i]);
                ancestors.put(neighbours[i], next);
            }
        } while (next != goal && next != null);
        if (next == null) {
            return null;
        }
        RescueObject current = goal;
        Stack<RescueObject> path = new Stack<RescueObject>();
        do {
            path.push(current);
        } while ((current = (RescueObject)ancestors.get(current)) != start && current != null);
        int[] result = new int[path.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((RescueObject)path.pop()).getID();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sortByDistance(List objects, RescueObject reference, Memory memory) {
        DistanceSorter distanceSorter = DISTANCE_SORTER;
        synchronized (distanceSorter) {
            SampleSearch.DISTANCE_SORTER.memory = memory;
            SampleSearch.DISTANCE_SORTER.reference = reference;
            Collections.sort(objects, DISTANCE_SORTER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sortByDistance(RescueObject[] objects, RescueObject reference, Memory memory) {
        DistanceSorter distanceSorter = DISTANCE_SORTER;
        synchronized (distanceSorter) {
            SampleSearch.DISTANCE_SORTER.memory = memory;
            SampleSearch.DISTANCE_SORTER.reference = reference;
            Arrays.sort(objects, DISTANCE_SORTER);
        }
    }

    private static class DistanceSorter
    implements Comparator {
        Memory memory;
        RescueObject reference;

        private DistanceSorter() {
        }

        public int compare(Object o1, Object o2) {
            try {
                double d1 = this.memory.getDistance(this.reference, (RescueObject)o1);
                double d2 = this.memory.getDistance(this.reference, (RescueObject)o2);
                if (d1 < d2) {
                    return -1;
                }
                if (d1 > d2) {
                    return 1;
                }
            }
            catch (CannotFindLocationException e) {
                System.err.println(e);
            }
            return ((RescueObject)o1).getID() - ((RescueObject)o2).getID();
        }
    }
}

