/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.objects;

import rescuecore.ArrayProperty;
import rescuecore.IntProperty;
import rescuecore.Property;
import rescuecore.objects.MotionlessObject;

public class Building
extends MotionlessObject {
    private IntProperty x;
    private IntProperty y;
    private IntProperty floors;
    private IntProperty attributes;
    private IntProperty ignition;
    private IntProperty fieryness;
    private IntProperty brokenness;
    private IntProperty code;
    private IntProperty ground;
    private IntProperty total;
    private IntProperty temperature;
    private IntProperty importance;
    private ArrayProperty entrances;
    private ArrayProperty apexes;

    public Building() {
        this.x = new IntProperty(25);
        this.y = new IntProperty(26);
        this.floors = new IntProperty(28);
        this.attributes = new IntProperty(29);
        this.ignition = new IntProperty(30);
        this.fieryness = new IntProperty(31);
        this.brokenness = new IntProperty(32);
        this.entrances = new ArrayProperty(33);
        this.code = new IntProperty(34);
        this.ground = new IntProperty(35);
        this.total = new IntProperty(36);
        this.apexes = new ArrayProperty(37);
        this.temperature = new IntProperty(47);
        this.importance = new IntProperty(48);
    }

    public Building(Building other) {
        this(other.getX(), other.getY(), other.getFloors(), other.getBuildingAttributes(), other.isIgnited(), other.getFieryness(), other.getBrokenness(), other.getEntrances(), other.getBuildingCode(), other.getGroundArea(), other.getTotalArea(), other.getApexes(), other.getTemperature(), other.getImportance());
    }

    public Building(int x, int y, int floors, int attributes, boolean ignition, int fieryness, int brokenness, int[] entrances, int code, int ground, int total, int[] apexes, int temperature, int importance) {
        this.x = new IntProperty(25, x);
        this.y = new IntProperty(26, y);
        this.floors = new IntProperty(28, floors);
        this.attributes = new IntProperty(29, attributes);
        this.ignition = new IntProperty(30, ignition);
        this.fieryness = new IntProperty(31, fieryness);
        this.brokenness = new IntProperty(32, brokenness);
        this.entrances = new ArrayProperty(33, entrances);
        this.code = new IntProperty(34, code);
        this.ground = new IntProperty(35, ground);
        this.total = new IntProperty(36, total);
        this.apexes = new ArrayProperty(37, apexes);
        this.temperature = new IntProperty(47, temperature);
        this.importance = new IntProperty(48, importance);
    }

    @Override
    public int getType() {
        return 32;
    }

    @Override
    public Property getProperty(int property) {
        switch (property) {
            case 25: {
                return this.x;
            }
            case 26: {
                return this.y;
            }
            case 28: {
                return this.floors;
            }
            case 29: {
                return this.attributes;
            }
            case 30: {
                return this.ignition;
            }
            case 31: {
                return this.fieryness;
            }
            case 32: {
                return this.brokenness;
            }
            case 33: {
                return this.entrances;
            }
            case 34: {
                return this.code;
            }
            case 35: {
                return this.ground;
            }
            case 36: {
                return this.total;
            }
            case 37: {
                return this.apexes;
            }
            case 47: {
                return this.temperature;
            }
            case 48: {
                return this.importance;
            }
        }
        return super.getProperty(property);
    }

    public int getX() {
        return this.x.getValue();
    }

    public boolean setX(int newX, int timestamp, Object source) {
        if (this.x.updateValue(newX, timestamp, source)) {
            this.firePropertyChanged(25, timestamp, source);
            return true;
        }
        return false;
    }

    public int getY() {
        return this.y.getValue();
    }

    public boolean setY(int newY, int timestamp, Object source) {
        if (this.y.updateValue(newY, timestamp, source)) {
            this.firePropertyChanged(26, timestamp, source);
            return true;
        }
        return false;
    }

    public int getFloors() {
        return this.floors.getValue();
    }

    public boolean setFloors(int f, int timestamp, Object source) {
        if (this.floors.updateValue(f, timestamp, source)) {
            this.firePropertyChanged(28, timestamp, source);
            return true;
        }
        return false;
    }

    public int getBuildingAttributes() {
        return this.attributes.getValue();
    }

    public boolean setBuildingAttributes(int b, int timestamp, Object source) {
        if (this.attributes.updateValue(b, timestamp, source)) {
            this.firePropertyChanged(29, timestamp, source);
            return true;
        }
        return false;
    }

    public boolean isIgnited() {
        return this.ignition.getValue() != 0;
    }

    public boolean setIgnition(boolean b, int timestamp, Object source) {
        if (this.ignition.updateValue(b ? 1 : 0, timestamp, source)) {
            this.firePropertyChanged(30, timestamp, source);
            return true;
        }
        return false;
    }

    public int getFieryness() {
        return this.fieryness.getValue();
    }

    public boolean setFieryness(int f, int timestamp, Object source) {
        if (this.fieryness.updateValue(f, timestamp, source)) {
            this.firePropertyChanged(31, timestamp, source);
            return true;
        }
        return false;
    }

    public int getBrokenness() {
        return this.brokenness.getValue();
    }

    public boolean setBrokenness(int b, int timestamp, Object source) {
        if (this.brokenness.updateValue(b, timestamp, source)) {
            this.firePropertyChanged(32, timestamp, source);
            return true;
        }
        return false;
    }

    public int[] getEntrances() {
        return this.entrances.getValues();
    }

    public boolean setEntrances(int[] e, int timestamp, Object source) {
        if (this.entrances.updateValues(e, timestamp, source)) {
            this.firePropertyChanged(33, timestamp, source);
            return true;
        }
        return false;
    }

    public void clearEntrances(int timestamp, Object source) {
        this.entrances.clear();
        this.firePropertyChanged(33, timestamp, source);
    }

    public void appendEntrances(int next, int timestamp, Object source) {
        this.entrances.append(next);
        this.firePropertyChanged(33, timestamp, source);
    }

    public int getBuildingCode() {
        return this.code.getValue();
    }

    public boolean setBuildingCode(int c, int timestamp, Object source) {
        if (this.code.updateValue(c, timestamp, source)) {
            this.firePropertyChanged(34, timestamp, source);
            return true;
        }
        return false;
    }

    public int getGroundArea() {
        return this.ground.getValue();
    }

    public boolean setGroundArea(int a, int timestamp, Object source) {
        if (this.ground.updateValue(a, timestamp, source)) {
            this.firePropertyChanged(35, timestamp, source);
            return true;
        }
        return false;
    }

    public int getTotalArea() {
        return this.total.getValue();
    }

    public boolean setTotalArea(int a, int timestamp, Object source) {
        if (this.total.updateValue(a, timestamp, source)) {
            this.firePropertyChanged(36, timestamp, source);
            return true;
        }
        return false;
    }

    public int[] getApexes() {
        return this.apexes.getValues();
    }

    public boolean setApexes(int[] a, int timestamp, Object source) {
        if (this.apexes.updateValues(a, timestamp, source)) {
            this.firePropertyChanged(37, timestamp, source);
            return true;
        }
        return false;
    }

    public void clearApexes(int timestamp, Object source) {
        this.apexes.clear();
        this.firePropertyChanged(37, timestamp, source);
    }

    public void appendApex(int next, int timestamp, Object source) {
        this.apexes.append(next);
        this.firePropertyChanged(37, timestamp, source);
    }

    public int getTemperature() {
        return this.temperature.getValue();
    }

    public boolean setTemperature(int value, int timestamp, Object source) {
        if (this.temperature.updateValue(value, timestamp, source)) {
            this.firePropertyChanged(47, timestamp, source);
            return true;
        }
        return false;
    }

    public int getImportance() {
        return this.importance.getValue();
    }

    public boolean setImportance(int i, int timestamp, Object source) {
        if (this.importance.updateValue(i, timestamp, source)) {
            this.firePropertyChanged(48, timestamp, source);
            return true;
        }
        return false;
    }

    public boolean isOnFire() {
        return this.getFieryness() > 0 && this.getFieryness() < 4;
    }

    public boolean isExtinguished() {
        return this.getFieryness() > 3 && this.getFieryness() < 7;
    }

    public boolean isBurntOut() {
        return this.getFieryness() == 7;
    }

    public boolean isUnburnt() {
        return this.getFieryness() == 0;
    }
}

