/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.commands;

import rescuecore.InputBuffer;
import rescuecore.OutputBuffer;
import rescuecore.commands.Command;

public class AKConnect
extends Command {
    private int version;
    private int[] agentTypes;
    private int requestID;
    private String name;

    public AKConnect(int version, int requestID, String name, int ... types) {
        super(64);
        this.agentTypes = types;
        this.version = version;
        this.requestID = requestID;
    }

    public AKConnect(InputBuffer in) {
        super(64);
        this.read(in);
    }

    @Override
    public void write(OutputBuffer out) {
        out.writeInt(this.requestID);
        out.writeInt(this.version);
        out.writeString(this.name);
        out.writeInt(this.agentTypes.length);
        for (int next : this.agentTypes) {
            out.writeInt(next);
        }
    }

    @Override
    public void read(InputBuffer in) {
        this.requestID = in.readInt();
        this.version = in.readInt();
        this.name = in.readString();
        this.agentTypes = new int[in.readInt()];
        for (int i = 0; i < this.agentTypes.length; ++i) {
            this.agentTypes[i] = in.readInt();
        }
    }

    public int getVersion() {
        return this.version;
    }

    public int[] getAgentTypes() {
        return this.agentTypes;
    }

    public int getRequestID() {
        return this.requestID;
    }
}

