/*
 * Decompiled with CFR 0.152.
 */
package rescuecore;

import rescuecore.HashMemory;
import rescuecore.Memory;
import rescuecore.RescueComponent;
import rescuecore.RescueConstants;
import rescuecore.RescueMessage;
import rescuecore.RescueObject;
import rescuecore.commands.Command;
import rescuecore.commands.SKConnect;

public abstract class Simulator
extends RescueComponent {
    protected int timeStep = -1;
    protected Memory memory;
    protected boolean running = false;

    protected Simulator() {
    }

    @Override
    public final int getComponentType() {
        return 2;
    }

    @Override
    public final Command generateConnectCommand() {
        return new SKConnect(this.getClass().getName());
    }

    @Override
    public final boolean handleConnectOK(Command c) {
        return true;
    }

    @Override
    public final String handleConnectError(Command c) {
        return null;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void shutdown() {
        this.running = false;
    }

    @Override
    public void handleMessage(Command c) {
        switch (c.getType()) {
            case 81: {
                this.handleCommands(c);
                break;
            }
            case 35: {
                RescueMessage ack = new RescueMessage();
                this.sendMessage(ack);
            }
        }
    }

    protected void initialise(RescueObject[] knowledge) {
        this.memory = this.generateMemory();
        for (int i = 0; i < knowledge.length; ++i) {
            this.memory.add(knowledge[i], 0, RescueConstants.SOURCE_INITIAL);
        }
    }

    protected Memory generateMemory() {
        return new HashMemory();
    }

    private void handleCommands(Command c) {
    }
}

