/*
 * Decompiled with CFR 0.152.
 */
package rescuecore;

import rescuecore.Agent;
import rescuecore.CannotFindLocationException;
import rescuecore.RescueObject;
import rescuecore.commands.Command;
import rescuecore.objects.Building;
import rescuecore.objects.Humanoid;
import rescuecore.objects.Road;

public abstract class PlatoonAgent
extends Agent {
    protected PlatoonAgent(int ... types) {
        super(types);
    }

    private Humanoid me() {
        return (Humanoid)this.memory.lookup(this.id);
    }

    protected RescueObject getLocation() {
        return this.memory.lookup(this.me().getPosition());
    }

    protected int getPosition() {
        return this.me().getPosition();
    }

    protected int getPositionExtra() {
        return this.me().getPositionExtra();
    }

    protected void move(int[] ids) {
        if (ids == null || ids.length == 0) {
            return;
        }
        this.appendCommand(Command.MOVE(this.id, this.timeStep, ids));
    }

    protected void extinguish(Building target) {
        try {
            int[] xy = this.memory.getXY(this.me());
            this.appendCommand(Command.EXTINGUISH(this.id, this.timeStep, target.getID()));
        }
        catch (CannotFindLocationException e) {
            System.err.println(e);
        }
    }

    protected void extinguish(Building target, int power) {
        try {
            int[] xy = this.memory.getXY(this.me());
            this.appendCommand(Command.EXTINGUISH(this.id, this.timeStep, target.getID(), this.memory.getAngle(this.me(), target), xy[0], xy[1], power));
        }
        catch (CannotFindLocationException e) {
            System.err.println(e);
        }
    }

    protected void clear(Road target) {
        this.appendCommand(Command.CLEAR(this.id, this.timeStep, target.getID()));
    }

    protected void rescue(Humanoid target) {
        this.appendCommand(Command.RESCUE(this.id, this.timeStep, target.getID()));
    }

    protected void load(Humanoid target) {
        this.appendCommand(Command.LOAD(this.id, this.timeStep, target.getID()));
    }

    protected void unload() {
        this.appendCommand(Command.UNLOAD(this.id, this.timeStep));
    }
}

