/*
 * Decompiled with CFR 0.152.
 */
package rescuecore;

import java.util.Collection;
import java.util.Iterator;
import rescuecore.InputBuffer;
import rescuecore.RescueObject;

public class Handy {
    private static final String[] HEX_DIGITS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
    private static final String CHARACTER_ENCODING = "US-ASCII";
    private static final Object PRINT_LOCK = new Object();

    private Handy() {
    }

    public static void printBytes(byte[] data) {
        Handy.printBytes(null, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printBytes(String header, byte[] data) {
        Object object = PRINT_LOCK;
        synchronized (object) {
            if (header != null) {
                System.out.println(header);
            }
            System.out.println("OFFSET\tBYTES");
            for (int i = 0; i < data.length; i += 4) {
                Handy.printBytes(i, data, "");
            }
        }
    }

    public static void printBytes(InputBuffer in) {
        Handy.printBytes(null, in);
    }

    public static void printBytes(String header, InputBuffer in) {
        int position = in.getPosition();
        byte[] temp = new byte[in.available()];
        in.readBytes(temp);
        Handy.printBytes(header, temp);
        in.setPosition(position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printBytes(int startIndex, byte[] data, String description) {
        StringBuffer buffer = new StringBuffer();
        Object object = PRINT_LOCK;
        synchronized (object) {
            buffer.append(startIndex);
            buffer.append("\t");
            for (int j = 0; j < 4; ++j) {
                if (data.length <= startIndex + j) continue;
                buffer.append(Handy.hex(data[startIndex + j]));
                if (j == 3) continue;
                buffer.append(" ");
            }
            buffer.append("\t");
            char charValue = (char)Handy.decodeInt(data, startIndex);
            if (Character.isLetterOrDigit(charValue)) {
                buffer.append(charValue);
            }
            buffer.append("\t");
            buffer.append(Handy.decodeInt(data, startIndex));
            buffer.append("\t");
            buffer.append(description);
            System.out.println(buffer.toString());
        }
    }

    public static String hex(byte b) {
        byte left = (byte)(b >> 4 & 0xF);
        byte right = (byte)(b & 0xF);
        return HEX_DIGITS[left] + HEX_DIGITS[right];
    }

    private static int decodeInt(byte[] buffer, int off) {
        int result = buffer[off] << 24 & 0xFF000000 | buffer[off + 1] << 16 & 0xFF0000 | buffer[off + 2] << 8 & 0xFF00 | buffer[off + 3] & 0xFF;
        return result;
    }

    public static String getTypeName(int type) {
        switch (type) {
            case 0: {
                return "TYPE_NULL";
            }
            case 64: {
                return "TYPE_CIVILIAN";
            }
            case 66: {
                return "TYPE_FIRE_BRIGADE";
            }
            case 67: {
                return "TYPE_AMBULANCE_TEAM";
            }
            case 68: {
                return "TYPE_POLICE_FORCE";
            }
            case 2: {
                return "TYPE_ROAD";
            }
            case 4: {
                return "TYPE_NODE";
            }
            case 3: {
                return "TYPE_RIVER";
            }
            case 5: {
                return "TYPE_RIVER_NODE";
            }
            case 32: {
                return "TYPE_BUILDING";
            }
            case 33: {
                return "TYPE_REFUGE";
            }
            case 34: {
                return "TYPE_FIRE_STATION";
            }
            case 35: {
                return "TYPE_AMBULANCE_CENTER";
            }
            case 36: {
                return "TYPE_POLICE_OFFICE";
            }
            case 1: {
                return "TYPE_WORLD";
            }
            case 65: {
                return "TYPE_CAR";
            }
        }
        return "Unknown type: " + type;
    }

    public static String getPropertyName(int type) {
        switch (type) {
            case 0: {
                return "PROPERTY_NULL";
            }
            case 1: {
                return "PROPERTY_START_TIME";
            }
            case 2: {
                return "PROPERTY_LONGITUDE";
            }
            case 3: {
                return "PROPERTY_LATITUDE";
            }
            case 4: {
                return "PROPERTY_WIND_FORCE";
            }
            case 5: {
                return "PROPERTY_WIND_DIRECTION";
            }
            case 25: {
                return "PROPERTY_X";
            }
            case 26: {
                return "PROPERTY_Y";
            }
            case 40: {
                return "PROPERTY_DIRECTION";
            }
            case 38: {
                return "PROPERTY_POSITION";
            }
            case 41: {
                return "PROPERTY_POSITION_HISTORY";
            }
            case 39: {
                return "PROPERTY_POSITION_EXTRA";
            }
            case 42: {
                return "PROPERTY_STAMINA";
            }
            case 43: {
                return "PROPERTY_HP";
            }
            case 44: {
                return "PROPERTY_DAMAGE";
            }
            case 45: {
                return "PROPERTY_BURIEDNESS";
            }
            case 28: {
                return "PROPERTY_FLOORS";
            }
            case 29: {
                return "PROPERTY_BUILDING_ATTRIBUTES";
            }
            case 30: {
                return "PROPERTY_IGNITION";
            }
            case 32: {
                return "PROPERTY_BROKENNESS";
            }
            case 31: {
                return "PROPERTY_FIERYNESS";
            }
            case 33: {
                return "PROPERTY_ENTRANCES";
            }
            case 34: {
                return "PROPERTY_BUILDING_CODE";
            }
            case 35: {
                return "PROPERTY_BUILDING_AREA_GROUND";
            }
            case 36: {
                return "PROPERTY_BUILDING_AREA_TOTAL";
            }
            case 37: {
                return "PROPERTY_BUILDING_APEXES";
            }
            case 46: {
                return "PROPERTY_WATER_QUANTITY";
            }
            case 6: {
                return "PROPERTY_HEAD";
            }
            case 7: {
                return "PROPERTY_TAIL";
            }
            case 8: {
                return "PROPERTY_LENGTH";
            }
            case 9: {
                return "PROPERTY_ROAD_KIND";
            }
            case 10: {
                return "PROPERTY_CARS_PASS_TO_HEAD";
            }
            case 11: {
                return "PROPERTY_CARS_PASS_TO_TAIL";
            }
            case 12: {
                return "PROPERTY_HUMANS_PASS_TO_HEAD";
            }
            case 13: {
                return "PROPERTY_HUMANS_PASS_TO_TAIL";
            }
            case 14: {
                return "PROPERTY_WIDTH";
            }
            case 15: {
                return "PROPERTY_BLOCK";
            }
            case 16: {
                return "PROPERTY_REPAIR_COST";
            }
            case 17: {
                return "PROPERTY_MEDIAN_STRIP";
            }
            case 18: {
                return "PROPERTY_LINES_TO_HEAD";
            }
            case 19: {
                return "PROPERTY_LINES_TO_TAIL";
            }
            case 20: {
                return "PROPERTY_WIDTH_FOR_WALKERS";
            }
            case 27: {
                return "PROPERTY_EDGES";
            }
            case 21: {
                return "PROPERTY_SIGNAL";
            }
            case 24: {
                return "PROPERTY_SIGNAL_TIMING";
            }
            case 22: {
                return "PROPERTY_SHORTCUT_TO_TURN";
            }
            case 23: {
                return "PROPERTY_POCKET_TO_TURN_ACROSS";
            }
            case 48: {
                return "PROPERTY_BUILDING_IMPORTANCE";
            }
            case 47: {
                return "PROPERTY_BUILDING_TEMPERATURE";
            }
        }
        return "Unknown property: " + type;
    }

    public static String getCommandTypeName(int header) {
        switch (header) {
            case 0: {
                return "HEADER_NULL";
            }
            case 18: {
                return "GK_CONNECT_OK";
            }
            case 19: {
                return "GK_CONNECT_ERROR";
            }
            case 16: {
                return "KG_CONNECT";
            }
            case 17: {
                return "KG_ACKNOWLEDGE";
            }
            case 32: {
                return "SK_CONNECT";
            }
            case 33: {
                return "SK_ACKNOWLEDGE";
            }
            case 34: {
                return "SK_UPDATE";
            }
            case 35: {
                return "KS_CONNECT_OK";
            }
            case 36: {
                return "KS_CONNECT_ERROR";
            }
            case 81: {
                return "COMMANDS";
            }
            case 80: {
                return "UPDATE";
            }
            case 48: {
                return "VK_CONNECT";
            }
            case 49: {
                return "VK_ACKNOWLEDGE";
            }
            case 50: {
                return "KV_CONNECT_OK";
            }
            case 51: {
                return "KV_CONNECT_ERROR";
            }
            case 64: {
                return "AK_CONNECT";
            }
            case 65: {
                return "AK_ACKNOWLEDGE";
            }
            case 128: {
                return "AK_REST";
            }
            case 129: {
                return "AK_MOVE";
            }
            case 134: {
                return "AK_EXTINGUISH";
            }
            case 137: {
                return "AK_CLEAR";
            }
            case 136: {
                return "AK_RESCUE";
            }
            case 130: {
                return "AK_LOAD";
            }
            case 131: {
                return "AK_UNLOAD";
            }
            case 144: {
                return "AK_CHANNEL";
            }
            case 145: {
                return "AK_REPAIR";
            }
            case 66: {
                return "KA_CONNECT_OK";
            }
            case 67: {
                return "KA_CONNECT_ERROR";
            }
            case 68: {
                return "KA_SENSE";
            }
            case 69: {
                return "KA_HEAR";
            }
        }
        return "Unknown header: " + header;
    }

    public static String getAgentTypeName(int type) {
        String s;
        StringBuffer result = new StringBuffer();
        if ((type & 1) == 1) {
            result.append("Civilian, ");
        }
        if ((type & 2) == 2) {
            result.append("Fire Brigade, ");
        }
        if ((type & 4) == 4) {
            result.append("Fire Station, ");
        }
        if ((type & 8) == 8) {
            result.append("Ambulance Team, ");
        }
        if ((type & 0x10) == 16) {
            result.append("Ambulance Center, ");
        }
        if ((type & 0x20) == 32) {
            result.append("Police Force, ");
        }
        if ((type & 0x40) == 64) {
            result.append("Police Office, ");
        }
        if ((s = result.toString()).length() > 0) {
            return s.substring(0, s.length() - 2);
        }
        return "Unknown";
    }

    public static String arrayAsString(int[] array) {
        if (array == null) {
            return "null";
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            result.append(array[i]);
            if (i >= array.length - 1) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public static String arrayAsString(Object[] array) {
        if (array == null) {
            return "null";
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            result.append(array[i] == null ? "null" : array[i].toString());
            if (i >= array.length - 1) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public static String collectionAsString(Collection c) {
        if (c == null) {
            return "null";
        }
        StringBuffer result = new StringBuffer();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Object next = it.next();
            result.append(next == null ? "null" : next.toString());
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public static RescueObject[] merge(RescueObject[] o1, RescueObject[] o2) {
        RescueObject[] result = new RescueObject[o1.length + o2.length];
        System.arraycopy(o1, 0, result, 0, o1.length);
        System.arraycopy(o2, 0, result, o1.length, o2.length);
        return result;
    }
}

