/*
 * Decompiled with CFR 0.152.
 */
package rescuecore;

import java.util.Collection;
import java.util.HashSet;
import rescuecore.Memory;
import rescuecore.RescueConstants;
import rescuecore.RescueObject;

public class ArrayMemory
extends Memory {
    private static final int DEFAULT_MEMORY_SIZE = 3000;
    private static final int DEFAULT_RESIZE_FACTOR = 1000;
    protected RescueObject[] data;
    private int dataSize;
    private int resizeFactor;

    public ArrayMemory() {
        this(3000, 1000);
    }

    public ArrayMemory(int size, int factor) {
        this.data = new RescueObject[size];
        this.resizeFactor = factor;
        this.dataSize = 0;
    }

    @Override
    public RescueObject lookup(int id) {
        return id >= this.data.length ? null : this.data[id];
    }

    @Override
    public Collection<RescueObject> getAllObjects() {
        HashSet<RescueObject> result = new HashSet<RescueObject>(this.dataSize);
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == null) continue;
            result.add(this.data[i]);
        }
        return result;
    }

    @Override
    public void getObjectsOfType(Collection<RescueObject> result, int ... types) {
        block0: for (int i = 0; i < this.data.length; ++i) {
            RescueObject next = this.data[i];
            int type = next.getType();
            for (int nextType : types) {
                if (type != nextType) continue;
                result.add(next);
                continue block0;
            }
        }
    }

    @Override
    public void add(RescueObject o, int timestamp, Object source) {
        int id = o.getID();
        if (id >= this.data.length) {
            this.resizeMemory(id + 1);
        }
        if (this.data[id] == null) {
            ++this.dataSize;
        }
        this.data[id] = o;
        super.add(o, timestamp, source);
    }

    @Override
    public void remove(RescueObject o) {
        int id = o.getID();
        if (id >= this.data.length) {
            this.resizeMemory(id + 1);
        }
        this.data[id] = null;
        super.remove(o);
    }

    private void resizeMemory(int sizeNeeded) {
        RescueObject[] newData = new RescueObject[Math.max(sizeNeeded, this.data.length + this.resizeFactor)];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        this.data = newData;
    }

    @Override
    public Memory copy() {
        ArrayMemory m = new ArrayMemory(this.data.length, this.resizeFactor);
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == null) continue;
            m.add(this.data[i].copy(), 0, RescueConstants.SOURCE_UNKNOWN);
        }
        return m;
    }
}

