/*
 * Decompiled with CFR 0.152.
 */
package rescuecore;

import rescuecore.Handy;
import rescuecore.HashMemory;
import rescuecore.Memory;
import rescuecore.RescueComponent;
import rescuecore.RescueConstants;
import rescuecore.RescueMessage;
import rescuecore.RescueObject;
import rescuecore.commands.AKAcknowledge;
import rescuecore.commands.AKConnect;
import rescuecore.commands.Command;
import rescuecore.commands.KAConnectError;
import rescuecore.commands.KAConnectOK;
import rescuecore.commands.KAHear;
import rescuecore.commands.KASense;
import rescuecore.debug.DebugMemoryListener;
import rescuecore.debug.DebugWriter;

public abstract class Agent
extends RescueComponent {
    private int[] agentTypes;
    protected int type;
    protected int id;
    protected int timeStep;
    protected Memory memory;
    private int tempID;
    private volatile boolean running;
    private static int NEXT_ID = 0;
    protected boolean debug = false;

    protected Agent(int ... types) {
        this.agentTypes = types;
        this.id = -1;
        this.timeStep = -1;
        this.type = -1;
        this.tempID = ++NEXT_ID;
    }

    @Override
    public final int getComponentType() {
        return 1;
    }

    @Override
    public final Command generateConnectCommand() {
        return new AKConnect(0, this.tempID, this.getClass().getName(), this.agentTypes);
    }

    @Override
    protected void appendCommand(Command c) {
        super.appendCommand(c);
        if (this.debug) {
            this.logObject(c);
        }
    }

    @Override
    public final boolean handleConnectOK(Command c) {
        KAConnectOK ok = (KAConnectOK)c;
        int requestID = ok.getRequestID();
        if (requestID == this.tempID) {
            this.id = ok.getAgentID();
            System.out.println("Connect succeeded for " + this.tempID + ". Kernel assigned id:" + this.id);
            try {
                RescueObject[] knowledge = ok.getKnowledge();
                this.initialise(knowledge);
                RescueMessage ack = new RescueMessage();
                ack.append(new AKAcknowledge(requestID, this.id));
                this.sendMessage(ack);
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
            this.timeStep = 0;
            this.running = true;
            return true;
        }
        System.out.println("Received a KA_CONNECT_OK for agent " + requestID + ", but I'm listening for a reply for " + this.tempID);
        return false;
    }

    @Override
    public final String handleConnectError(Command c) {
        KAConnectError error = (KAConnectError)c;
        int requestID = error.getRequestID();
        String reason = error.getReason();
        if (requestID == this.tempID) {
            return reason;
        }
        System.out.println("Received a KA_CONNECT_ERROR (" + reason + ") for agent " + requestID + ", but I'm listening for a reply for " + this.tempID);
        return null;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void shutdown() {
        this.running = false;
    }

    @Override
    public final void handleMessage(Command c) {
        switch (c.getType()) {
            case 68: {
                this.handleSense((KASense)c);
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                this.handleHear(c);
                break;
            }
            case 66: {
                if (!this.running) break;
                KAConnectOK ok = (KAConnectOK)c;
                int requestID = ok.getRequestID();
                System.out.println(this + " just received a KA_CONNECT_OK to " + requestID + " - my tempID is " + this.tempID);
                if (requestID != this.tempID) break;
                int newID = ok.getAgentID();
                System.out.println("Old ID: " + this.id + ", new ID: " + newID);
                this.id = newID;
                RescueMessage ack = new RescueMessage();
                ack.append(new AKAcknowledge(requestID, this.id));
                this.sendMessage(ack);
                break;
            }
            default: {
                this.handleOtherMessage(c);
            }
        }
        this.logObject(c);
    }

    protected void handleOtherMessage(Command c) {
        System.out.println("Timestep " + this.timeStep + ": " + this + " received a weird command: " + Handy.getCommandTypeName(c.getType()));
    }

    private void handleSense(Command c) {
        KASense sense = (KASense)c;
        try {
            int newTimeStep = sense.getTime();
            if (newTimeStep < this.timeStep) {
                System.err.println(this + " just moved back in time! It was timestep " + this.timeStep + " and now it's timestep " + newTimeStep);
            }
            if (newTimeStep > this.timeStep + 1) {
                System.err.println(this + " just skipped ahead in time! It was timestep " + this.timeStep + " and now it's timestep " + newTimeStep);
            }
            this.timeStep = newTimeStep;
            this.memory.update(sense);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.sense();
        this.flushCommands();
        DebugWriter.flush(this);
    }

    private void handleHear(Command c) {
        KAHear hear = (KAHear)c;
        int toID = hear.getToID();
        int fromID = hear.getFromID();
        int length = hear.getLength();
        byte[] msg = hear.getData();
        byte channel = hear.getChannel();
        this.hear(fromID, msg, channel);
    }

    private RescueObject me() {
        return this.memory.lookup(this.id);
    }

    public String toString() {
        if (!this.running) {
            return "Unconnected agent. Temporary ID: " + this.tempID;
        }
        return Handy.getTypeName(this.type) + " (" + this.id + ")";
    }

    public final Memory getMemory() {
        return this.memory;
    }

    public final int getType() {
        return this.type;
    }

    public final int getID() {
        return this.id;
    }

    protected void enableDebug(String target) {
        this.debug = true;
        DebugWriter.register(this, this.toString(), target);
    }

    protected void disableDebug() {
        this.debug = false;
    }

    public final void logObject(Object obj) {
        if (this.debug) {
            DebugWriter.logUserObject(this, obj, this.timeStep);
        }
    }

    protected void initialise(RescueObject[] knowledge) {
        this.memory = this.generateMemory();
        for (int i = 0; i < knowledge.length; ++i) {
            this.memory.add(knowledge[i], 0, RescueConstants.SOURCE_INITIAL);
        }
        this.type = this.me().getType();
        if (this.debug) {
            DebugWriter.logInitialObjects(this, this.memory.getAllObjects());
            this.memory.addMemoryListener(new DebugMemoryListener(this));
        }
    }

    protected Memory generateMemory() {
        return new HashMemory();
    }

    protected abstract void sense();

    protected void hear(int from, byte[] msg, byte channel) {
    }

    protected final void say(byte[] message) {
        this.appendCommand(Command.SAY(this.id, this.timeStep, message, message.length));
    }

    protected final void tell(byte[] message, byte channel) {
        this.appendCommand(Command.TELL(this.id, this.timeStep, message, message.length, channel));
    }
}

