/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.view;

import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.ImageIcon;
import rescuecore2.misc.gui.ScreenTransform;
import rescuecore2.standard.entities.Building;
import rescuecore2.standard.view.BuildingLayer;
import rescuecore2.standard.view.StandardEntityViewLayer;

public class BuildingIconLayer
extends StandardEntityViewLayer<Building> {
    private static final int ICON_SIZE = 32;
    private static final ImageIcon FIRE_STATION = new ImageIcon(BuildingLayer.class.getClassLoader().getResource("rescuecore2/standard/view/FireStation-32x32.png"));
    private static final ImageIcon POLICE_OFFICE = new ImageIcon(BuildingLayer.class.getClassLoader().getResource("rescuecore2/standard/view/PoliceOffice-32x32.png"));
    private static final ImageIcon AMBULANCE_CENTRE = new ImageIcon(BuildingLayer.class.getClassLoader().getResource("rescuecore2/standard/view/AmbulanceCentre-32x32.png"));
    private static final ImageIcon REFUGE = new ImageIcon(BuildingLayer.class.getClassLoader().getResource("rescuecore2/standard/view/Refuge-32x32.png"));

    public BuildingIconLayer() {
        super(Building.class);
    }

    public String getName() {
        return "Building icons";
    }

    @Override
    public Shape render(Building b, Graphics2D g, ScreenTransform t) {
        ImageIcon icon = null;
        switch (b.getStandardURN()) {
            case REFUGE: {
                icon = REFUGE;
                break;
            }
            case FIRE_STATION: {
                icon = FIRE_STATION;
                break;
            }
            case AMBULANCE_CENTRE: {
                icon = AMBULANCE_CENTRE;
                break;
            }
            case POLICE_OFFICE: {
                icon = POLICE_OFFICE;
                break;
            }
        }
        if (icon != null) {
            int x = t.xToScreen((double)b.getX()) - icon.getIconWidth() / 2;
            int y = t.yToScreen((double)b.getY()) - icon.getIconHeight() / 2;
            icon.paintIcon(null, g, x, y);
        }
        return null;
    }
}

