/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import rescuecore2.misc.Pair;
import rescuecore2.standard.entities.Human;
import rescuecore2.standard.entities.StandardWorldModel;

public abstract class AgentPath {
    public static AgentPath computePath(Human human, StandardWorldModel world) {
        if (human == null) {
            throw new IllegalArgumentException("Agent must not be null");
        }
        if (!human.isPositionDefined()) {
            throw new IllegalArgumentException("Agent has an undefined position");
        }
        if (!human.isPositionHistoryDefined()) {
            return null;
        }
        int[] history = human.getPositionHistory();
        if (history.length > 2) {
            return new CoordinatePath(history);
        }
        return null;
    }

    public abstract Pair<Integer, Integer> getPointOnPath(double var1);

    public abstract double getLength();

    private static class CoordinatePathSegment
    extends AbstractPath {
        CoordinatePathSegment(int fromX, int fromY, int toX, int toY) {
            this.setStart(fromX, fromY);
            this.setEnd(toX, toY);
            this.setDescription("From " + fromX + ", " + fromY + " to " + toX + ", " + toY);
            this.computeLength();
        }
    }

    private static class CoordinatePath
    extends CompositePath {
        CoordinatePath(int[] history) {
            int fromX = history[0];
            int fromY = history[1];
            for (int i = 2; i < history.length; i += 2) {
                int toX = history[i];
                int toY = history[i + 1];
                this.addPath(new CoordinatePathSegment(fromX, fromY, toX, toY));
                fromX = toX;
                fromY = toY;
            }
        }
    }

    private static abstract class AbstractPath
    extends AgentPath {
        private Pair<Integer, Integer> start;
        private Pair<Integer, Integer> end;
        private double length;
        private String description;

        private AbstractPath() {
        }

        protected void setStart(int sX, int sY) {
            this.start = new Pair((Object)sX, (Object)sY);
        }

        protected void setEnd(int eX, int eY) {
            this.end = new Pair((Object)eX, (Object)eY);
        }

        protected void setStart(Pair<Integer, Integer> s) {
            this.start = s;
        }

        protected void setEnd(Pair<Integer, Integer> e) {
            this.end = e;
        }

        protected void setLength(double l) {
            this.length = l;
        }

        protected void computeLength() {
            int dx = (Integer)this.end.first() - (Integer)this.start.first();
            int dy = (Integer)this.end.second() - (Integer)this.start.second();
            this.length = Math.hypot(dx, dy);
        }

        protected void setDescription(String d) {
            this.description = d;
        }

        @Override
        public double getLength() {
            return this.length;
        }

        @Override
        public Pair<Integer, Integer> getPointOnPath(double d) {
            double dx = (Integer)this.end.first() - (Integer)this.start.first();
            double dy = (Integer)this.end.second() - (Integer)this.start.second();
            int x = (Integer)this.start.first() + (int)(d * dx);
            int y = (Integer)this.start.second() + (int)(d * dy);
            return new Pair((Object)x, (Object)y);
        }

        public String toString() {
            return this.description;
        }
    }

    private static class CompositePath
    extends AgentPath {
        private List<AgentPath> parts = new ArrayList<AgentPath>();

        CompositePath() {
        }

        void addPath(AgentPath p) {
            this.parts.add(p);
        }

        @Override
        public double getLength() {
            double d = 0.0;
            for (AgentPath next : this.parts) {
                d += next.getLength();
            }
            return d;
        }

        @Override
        public Pair<Integer, Integer> getPointOnPath(double d) {
            double length = this.getLength();
            double point = d * length;
            AgentPath result = null;
            for (AgentPath next : this.parts) {
                double nextLength = next.getLength();
                if (nextLength > point) {
                    result = next;
                    break;
                }
                point -= nextLength;
            }
            if (result == null) {
                return this.parts.get(this.parts.size() - 1).getPointOnPath(1.0);
            }
            double p = point / result.getLength();
            return result.getPointOnPath(p);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            Iterator<AgentPath> it = this.parts.iterator();
            while (it.hasNext()) {
                result.append(it.next());
                if (!it.hasNext()) continue;
                result.append(", ");
            }
            return result.toString();
        }
    }
}

