/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.kernel.comms;

import java.util.Map;
import rescuecore2.config.Config;
import rescuecore2.log.Logger;
import rescuecore2.misc.collections.LazyMap;
import rescuecore2.standard.entities.Human;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardEntityURN;
import rescuecore2.standard.entities.StandardWorldModel;
import rescuecore2.standard.kernel.comms.AbstractChannel;
import rescuecore2.standard.kernel.comms.InvalidMessageException;
import rescuecore2.standard.messages.AKSpeak;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;

public class VoiceChannel
extends AbstractChannel {
    private static final String RANGE_SUFFIX = ".range";
    private static final String MESSAGE_SIZE_SUFFIX = ".messages.size";
    private static final String MESSAGE_MAX_SUFFIX = ".messages.max";
    private int range;
    private int maxSize;
    private int maxMessages;
    private Map<EntityID, Integer> uttered;
    private StandardWorldModel world;

    public VoiceChannel(Config config, int channelID, StandardWorldModel world) {
        super(channelID);
        this.world = world;
        this.range = config.getIntValue("comms.channels." + channelID + RANGE_SUFFIX);
        this.maxSize = config.getIntValue("comms.channels." + channelID + MESSAGE_SIZE_SUFFIX);
        this.maxMessages = config.getIntValue("comms.channels." + channelID + MESSAGE_MAX_SUFFIX);
        this.uttered = new LazyMap<EntityID, Integer>(){

            public Integer createValue() {
                return 0;
            }
        };
    }

    @Override
    public void timestep() {
        super.timestep();
        this.uttered.clear();
    }

    @Override
    protected void pushImpl(AKSpeak speak) throws InvalidMessageException {
        EntityID agentID = speak.getAgentID();
        Entity e = this.world.getEntity(agentID);
        if (!(e instanceof Human)) {
            throw new InvalidMessageException("Agent " + agentID + " is not a human: " + (e == null ? "null" : e.getClass().getName()));
        }
        byte[] data = speak.getContent();
        int count = this.uttered.get(agentID);
        if (count >= this.maxMessages) {
            throw new InvalidMessageException("Agent " + agentID + " has uttered too many voice messages on " + this);
        }
        if (data.length > this.maxSize) {
            throw new InvalidMessageException("Agent " + agentID + " tried to send an oversize voice message: " + data.length + " bytes but the limit is " + this.maxSize);
        }
        this.uttered.put(agentID, count + 1);
        StandardEntity sender = (StandardEntity)this.world.getEntity(agentID);
        for (StandardEntity target : this.world.getEntitiesOfType(StandardEntityURN.FIRE_BRIGADE, StandardEntityURN.AMBULANCE_TEAM, StandardEntityURN.POLICE_FORCE, StandardEntityURN.CIVILIAN)) {
            if (this.world.getDistance(sender, target) > this.range) continue;
            Logger.debug((String)((Object)((Object)target) + " can hear voice message from " + (Object)((Object)sender)));
            this.addMessageForAgent((Entity)target, speak);
        }
    }

    public String toString() {
        return "Voice channel " + this.channelID + " (range = " + this.range + ", max " + this.maxMessages + " messages of size " + this.maxSize + ")";
    }
}

