/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.kernel.comms;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kernel.AbstractCommunicationModel;
import rescuecore2.config.Config;
import rescuecore2.log.Logger;
import rescuecore2.messages.Command;
import rescuecore2.standard.entities.AmbulanceCentre;
import rescuecore2.standard.entities.AmbulanceTeam;
import rescuecore2.standard.entities.Civilian;
import rescuecore2.standard.entities.FireBrigade;
import rescuecore2.standard.entities.FireStation;
import rescuecore2.standard.entities.PoliceForce;
import rescuecore2.standard.entities.PoliceOffice;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardEntityURN;
import rescuecore2.standard.entities.StandardWorldModel;
import rescuecore2.standard.kernel.comms.AbstractChannel;
import rescuecore2.standard.kernel.comms.ChainedNoise;
import rescuecore2.standard.kernel.comms.Channel;
import rescuecore2.standard.kernel.comms.DropoutNoise;
import rescuecore2.standard.kernel.comms.FailureNoise;
import rescuecore2.standard.kernel.comms.InvalidMessageException;
import rescuecore2.standard.kernel.comms.Noise;
import rescuecore2.standard.kernel.comms.RadioChannel;
import rescuecore2.standard.kernel.comms.StaticNoise;
import rescuecore2.standard.kernel.comms.VoiceChannel;
import rescuecore2.standard.messages.AKSpeak;
import rescuecore2.standard.messages.AKSubscribe;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.WorldModel;

public class ChannelCommunicationModel
extends AbstractCommunicationModel {
    public static final String PREFIX = "comms.channels.";
    private static final String COUNT_KEY = "comms.channels.count";
    private static final String PLATOON_MAX_CHANNELS_KEY = "comms.channels.max.platoon";
    private static final String CENTRE_MAX_CHANNELS_KEY = "comms.channels.max.centre";
    private static final String TYPE_SUFFIX = ".type";
    private static final String NOISE_SUFFIX = ".noise";
    private static final String INPUT_SUFFIX = ".input";
    private static final String OUTPUT_SUFFIX = ".output";
    private static final String TYPE_VOICE = "voice";
    private static final String TYPE_RADIO = "radio";
    private static final String NOISE_TYPE_DROPOUT = "dropout";
    private static final String NOISE_TYPE_STATIC = "static";
    private Map<Integer, Channel> channels = new HashMap<Integer, Channel>();
    private int platoonMax;
    private int centreMax;
    private StandardWorldModel world;

    public String toString() {
        return "Channel communication model";
    }

    public void initialise(Config config, WorldModel<? extends Entity> model) {
        super.initialise(config, model);
        this.channels.clear();
        this.world = StandardWorldModel.createStandardWorldModel(model);
        int count = config.getIntValue(COUNT_KEY);
        for (int i = 0; i < count; ++i) {
            String type = config.getValue(PREFIX + i + TYPE_SUFFIX);
            AbstractChannel channel = null;
            if (TYPE_VOICE.equals(type)) {
                channel = new VoiceChannel(config, i, this.world);
            } else if (TYPE_RADIO.equals(type)) {
                channel = new RadioChannel(config, i);
            } else {
                Logger.error((String)("Unrecognised channel type: comms.channels." + i + TYPE_SUFFIX + " = '" + type + "'"));
            }
            if (channel == null) continue;
            String key = PREFIX + i + NOISE_SUFFIX;
            Noise input = this.createNoiseObjects(config, key + INPUT_SUFFIX);
            Noise output = this.createNoiseObjects(config, key + OUTPUT_SUFFIX);
            channel.setInputNoise(input);
            channel.setOutputNoise(output);
            this.channels.put(i, channel);
            Logger.info((String)("Created channel: " + channel));
        }
        this.platoonMax = config.getIntValue(PLATOON_MAX_CHANNELS_KEY, 1);
        this.centreMax = config.getIntValue(CENTRE_MAX_CHANNELS_KEY, 2);
    }

    public void process(int time, Collection<? extends Command> agentCommands) {
        Logger.debug((String)("ChannelCommunicationModel processing commands at time " + time + ": " + agentCommands));
        super.process(time, agentCommands);
        for (Channel channel : this.channels.values()) {
            channel.timestep();
        }
        for (Command command : agentCommands) {
            if (!(command instanceof AKSubscribe)) continue;
            this.processSubscribe((AKSubscribe)command);
        }
        for (Command command : agentCommands) {
            if (!(command instanceof AKSpeak)) continue;
            try {
                AKSpeak speak = (AKSpeak)command;
                int channelNumber = speak.getChannel();
                Channel channel = this.channels.get(channelNumber);
                Logger.debug((String)("Processing speak: " + (Object)((Object)speak)));
                if (channel == null) {
                    throw new InvalidMessageException("Unrecognised channel: " + channelNumber);
                }
                channel.push(speak);
            }
            catch (InvalidMessageException e) {
                Logger.warn((String)("Invalid message: " + command + ": " + e.getMessage()));
            }
        }
        for (StandardEntity standardEntity : this.world.getEntitiesOfType(StandardEntityURN.FIRE_BRIGADE, StandardEntityURN.FIRE_STATION, StandardEntityURN.POLICE_FORCE, StandardEntityURN.POLICE_OFFICE, StandardEntityURN.AMBULANCE_TEAM, StandardEntityURN.AMBULANCE_CENTRE, StandardEntityURN.CIVILIAN)) {
            for (Channel channel : this.channels.values()) {
                this.addHearing((Entity)standardEntity, channel.getMessagesForAgent((Entity)standardEntity));
            }
        }
    }

    public Collection<Channel> getAllChannels() {
        return Collections.unmodifiableCollection(this.channels.values());
    }

    private Noise createNoiseObjects(Config config, String key) {
        ChainedNoise result = new ChainedNoise();
        result.addChild(this.lookForFailure(config, key));
        result.addChild(this.lookForDropout(config, key));
        result.addChild(this.lookForStatic(config, key));
        return result;
    }

    private Noise lookForFailure(Config config, String key) {
        if (config.getBooleanValue(key + ".failure.use", false)) {
            return new FailureNoise(config.getFloatValue(key + ".failure.p"), config.getRandom());
        }
        return null;
    }

    private Noise lookForDropout(Config config, String key) {
        if (config.getBooleanValue(key + ".dropout.use", false)) {
            return new DropoutNoise(config.getFloatValue(key + ".dropout.p"), config.getRandom());
        }
        return null;
    }

    private Noise lookForStatic(Config config, String key) {
        if (config.getBooleanValue(key + ".static.use", false)) {
            return new StaticNoise(config.getFloatValue(key + ".static.p"), config.getRandom());
        }
        return null;
    }

    private void processSubscribe(AKSubscribe sub) {
        int max;
        Logger.debug((String)("Processing subscribe message : " + (Object)((Object)sub)));
        List<Integer> requested = sub.getChannels();
        EntityID id = sub.getAgentID();
        Entity entity = this.world.getEntity(id);
        if (entity == null) {
            Logger.warn((String)("Couldn't find entity " + id));
            return;
        }
        if (entity instanceof FireBrigade || entity instanceof PoliceForce || entity instanceof AmbulanceTeam || entity instanceof Civilian) {
            max = this.platoonMax;
        } else if (entity instanceof FireStation || entity instanceof PoliceOffice || entity instanceof AmbulanceCentre) {
            max = this.centreMax;
        } else {
            Logger.warn((String)("I don't know how to handle subscriptions for this entity: " + entity));
            return;
        }
        if (requested.size() > max) {
            Logger.warn((String)("Agent " + id + " tried to subscribe to " + requested.size() + " channels but only " + max + " allowed"));
            return;
        }
        for (Channel next : this.channels.values()) {
            next.removeSubscriber(entity);
        }
        Iterator<Object> i$ = requested.iterator();
        while (i$.hasNext()) {
            int next = (Integer)i$.next();
            Channel channel = this.channels.get(next);
            if (channel == null) {
                Logger.warn((String)("Agent " + id + " tried to subscribe to non-existant channel " + next));
                continue;
            }
            channel.addSubscriber(entity);
        }
    }
}

