/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import misc.HumanAttributes;

public class MiscSimulatorGUI
extends JPanel {
    private static final int COLUMN_ID = 0;
    private static final int COLUMN_HP = 1;
    private static final int COLUMN_DAMAGE = 2;
    private static final int COLUMN_BURY = 3;
    private static final int COLUMN_COLLAPSE = 4;
    private static final int COLUMN_FIRE = 5;
    private static final int COLUMN_BURIEDNESS = 6;
    private static final int COLUMNS = 7;
    private MiscTableModel model = new MiscTableModel();

    public MiscSimulatorGUI() {
        super(new BorderLayout());
        this.add((Component)new JScrollPane(new JTable(this.model)), "Center");
    }

    public void refresh(Collection<HumanAttributes> data) {
        this.model.setData(data.toArray(new HumanAttributes[data.size()]));
    }

    private static class MiscTableModel
    extends AbstractTableModel {
        private HumanAttributes[] data;

        private MiscTableModel() {
        }

        void setData(HumanAttributes[] data) {
            this.data = data;
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.data == null ? 0 : this.data.length;
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public Object getValueAt(int row, int col) {
            HumanAttributes att = this.data[row];
            switch (col) {
                case 0: {
                    return att.getID();
                }
                case 1: {
                    return att.getHuman().isHPDefined() ? String.valueOf(att.getHuman().getHP()) : "undefined";
                }
                case 2: {
                    return att.getHuman().isDamageDefined() ? String.valueOf(att.getHuman().getDamage()) : "undefined";
                }
                case 3: {
                    return att.getBuriednessDamage();
                }
                case 4: {
                    return att.getCollapseDamage();
                }
                case 5: {
                    return att.getFireDamage();
                }
                case 6: {
                    return att.getHuman().isBuriednessDefined() ? String.valueOf(att.getHuman().getBuriedness()) : "undefined";
                }
            }
            throw new IllegalArgumentException("Unrecognised column: " + col);
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "ID";
                }
                case 1: {
                    return "HP";
                }
                case 2: {
                    return "Total damage";
                }
                case 3: {
                    return "Buriedness damage";
                }
                case 4: {
                    return "Collapse damage";
                }
                case 5: {
                    return "Fire damage";
                }
                case 6: {
                    return "Buriedness";
                }
            }
            throw new IllegalArgumentException("Unrecognised column: " + col);
        }
    }
}

