/*
 * Decompiled with CFR 0.152.
 */
package maps.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import maps.MapException;
import maps.MapReader;
import maps.gml.GMLMap;
import maps.validate.GMLConnectivityValidator;
import maps.validate.GMLShapeValidator;
import maps.validate.GMLTraversabilityValidator;
import maps.validate.MapValidator;
import maps.validate.ValidationError;

public final class GMLMapValidator {
    private static List<MapValidator<GMLMap>> validators = new ArrayList<MapValidator<GMLMap>>();

    private GMLMapValidator() {
    }

    public static List<MapValidator<GMLMap>> getDefaultValidators() {
        return new ArrayList<MapValidator<GMLMap>>(validators);
    }

    public static void main(String[] args) {
        try {
            GMLMap map = (GMLMap)MapReader.readMap(args[0]);
            boolean hasErrors = true;
            for (MapValidator<GMLMap> val : validators) {
                Collection<ValidationError> errors = val.validate(map);
                for (ValidationError e : errors) {
                    System.err.println(e);
                    hasErrors = true;
                }
            }
            if (!hasErrors) {
                System.out.println("No errors have been found.");
            }
        }
        catch (MapException e) {
            e.printStackTrace();
        }
    }

    static {
        validators.add(new GMLConnectivityValidator());
        validators.add(new GMLShapeValidator());
        validators.add(new GMLTraversabilityValidator());
    }
}

