/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.view;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import maps.gml.GMLBuilding;
import maps.gml.GMLCoordinates;
import maps.gml.GMLEdge;
import maps.gml.GMLMap;
import maps.gml.GMLNode;
import maps.gml.GMLObject;
import maps.gml.GMLRoad;
import maps.gml.GMLSpace;
import maps.gml.GMLTools;
import maps.gml.view.BuildingDecorator;
import maps.gml.view.CrossNodeDecorator;
import maps.gml.view.EdgeDecorator;
import maps.gml.view.FilledShapeDecorator;
import maps.gml.view.LineEdgeDecorator;
import maps.gml.view.NodeDecorator;
import maps.gml.view.Overlay;
import maps.gml.view.RoadDecorator;
import maps.gml.view.SpaceDecorator;
import rescuecore2.misc.gui.PanZoomListener;
import rescuecore2.misc.gui.ScreenTransform;

public class GMLMapViewer
extends JComponent {
    private static final Color BUILDING_COLOUR = new Color(0, 255, 0, 128);
    private static final Color ROAD_COLOUR = new Color(192, 192, 192, 128);
    private static final Color SPACE_COLOUR = new Color(0, 128, 0, 128);
    private static final Color GRID_COLOUR = new Color(64, 64, 64, 64);
    private static final Color NODE_COLOUR = Color.BLACK;
    private static final int NODE_SIZE = 3;
    private static final Color EDGE_COLOUR = Color.BLACK;
    private static final double MIN_ZOOM_BOUNDS_SIZE = 0.1;
    private GMLMap map;
    private ScreenTransform transform;
    private PanZoomListener panZoom = new PanZoomListener((JComponent)this);
    private transient NodeDecorator defaultNodeDecorator = new CrossNodeDecorator(NODE_COLOUR, 3);
    private transient Map<GMLNode, NodeDecorator> nodeDecorators;
    private transient EdgeDecorator defaultEdgeDecorator = new LineEdgeDecorator(EDGE_COLOUR);
    private transient Map<GMLEdge, EdgeDecorator> edgeDecorators;
    private transient BuildingDecorator defaultBuildingDecorator;
    private transient Map<GMLBuilding, BuildingDecorator> buildingDecorators;
    private transient RoadDecorator defaultRoadDecorator;
    private transient Map<GMLRoad, RoadDecorator> roadDecorators;
    private transient SpaceDecorator defaultSpaceDecorator;
    private transient Map<GMLSpace, SpaceDecorator> spaceDecorators;
    private transient List<Overlay> overlays;
    private boolean grid;
    private double gridResolution;

    public GMLMapViewer() {
        this(null);
    }

    public GMLMapViewer(GMLMap map) {
        FilledShapeDecorator d = new FilledShapeDecorator(BUILDING_COLOUR, ROAD_COLOUR, SPACE_COLOUR);
        this.defaultBuildingDecorator = d;
        this.defaultRoadDecorator = d;
        this.defaultSpaceDecorator = d;
        this.nodeDecorators = new HashMap<GMLNode, NodeDecorator>();
        this.edgeDecorators = new HashMap<GMLEdge, EdgeDecorator>();
        this.buildingDecorators = new HashMap<GMLBuilding, BuildingDecorator>();
        this.roadDecorators = new HashMap<GMLRoad, RoadDecorator>();
        this.spaceDecorators = new HashMap<GMLSpace, SpaceDecorator>();
        this.grid = false;
        this.gridResolution = 1.0;
        this.overlays = new ArrayList<Overlay>();
        this.setMap(map);
    }

    public void setMap(GMLMap map) {
        this.map = map;
        this.transform = null;
        if (map != null) {
            this.transform = !map.hasSize() ? new ScreenTransform(0.0, 0.0, 100.0, 100.0) : new ScreenTransform(map.getMinX(), map.getMinY(), map.getMaxX(), map.getMaxY());
        }
        this.panZoom.setScreenTransform(this.transform);
    }

    public void view(GMLObject ... objects) {
        this.view(Arrays.asList(objects));
    }

    public void view(List<? extends GMLObject> objects) {
        if (objects == null || objects.isEmpty()) {
            return;
        }
        Rectangle2D bounds = GMLTools.getObjectBounds(objects);
        if (bounds == null) {
            return;
        }
        if (bounds.getWidth() < 0.1) {
            bounds = new Rectangle2D.Double(bounds.getX() - 0.05, bounds.getY(), 0.1, bounds.getHeight());
        }
        if (bounds.getHeight() < 0.1) {
            bounds = new Rectangle2D.Double(bounds.getX(), bounds.getY() - 0.05, bounds.getWidth(), 0.1);
        }
        this.transform.show(bounds);
    }

    public void viewAll() {
        this.transform.resetZoom();
    }

    public PanZoomListener getPanZoomListener() {
        return this.panZoom;
    }

    public void setDefaultNodeDecorator(NodeDecorator defaultDecorator) {
        this.defaultNodeDecorator = defaultDecorator;
    }

    public NodeDecorator getDefaultNodeDecorator() {
        return this.defaultNodeDecorator;
    }

    public void setNodeDecorator(NodeDecorator decorator, GMLNode ... nodes) {
        this.setNodeDecorator(decorator, Arrays.asList(nodes));
    }

    public void setNodeDecorator(NodeDecorator decorator, Collection<? extends GMLNode> nodes) {
        for (GMLNode gMLNode : nodes) {
            this.nodeDecorators.put(gMLNode, decorator);
        }
    }

    public NodeDecorator getNodeDecorator(GMLNode node) {
        NodeDecorator result = this.nodeDecorators.get(node);
        if (result == null) {
            result = this.defaultNodeDecorator;
        }
        return result;
    }

    public void clearNodeDecorator(GMLNode ... nodes) {
        this.clearNodeDecorator(Arrays.asList(nodes));
    }

    public void clearNodeDecorator(Collection<? extends GMLNode> nodes) {
        for (GMLNode gMLNode : nodes) {
            this.nodeDecorators.remove(gMLNode);
        }
    }

    public void clearAllNodeDecorators() {
        this.nodeDecorators.clear();
    }

    public void setDefaultEdgeDecorator(EdgeDecorator defaultDecorator) {
        this.defaultEdgeDecorator = defaultDecorator;
    }

    public EdgeDecorator getDefaultEdgeDecorator() {
        return this.defaultEdgeDecorator;
    }

    public void setEdgeDecorator(EdgeDecorator decorator, GMLEdge ... edges) {
        this.setEdgeDecorator(decorator, Arrays.asList(edges));
    }

    public void setEdgeDecorator(EdgeDecorator decorator, Collection<? extends GMLEdge> edges) {
        for (GMLEdge gMLEdge : edges) {
            this.edgeDecorators.put(gMLEdge, decorator);
        }
    }

    public EdgeDecorator getEdgeDecorator(GMLEdge edge) {
        EdgeDecorator result = this.edgeDecorators.get(edge);
        if (result == null) {
            result = this.defaultEdgeDecorator;
        }
        return result;
    }

    public void clearEdgeDecorator(GMLEdge ... edges) {
        this.clearEdgeDecorator(Arrays.asList(edges));
    }

    public void clearEdgeDecorator(Collection<? extends GMLEdge> edges) {
        for (GMLEdge gMLEdge : edges) {
            this.edgeDecorators.remove(gMLEdge);
        }
    }

    public void clearAllEdgeDecorators() {
        this.edgeDecorators.clear();
    }

    public void setDefaultBuildingDecorator(BuildingDecorator defaultDecorator) {
        this.defaultBuildingDecorator = defaultDecorator;
    }

    public BuildingDecorator getDefaultBuildingDecorator() {
        return this.defaultBuildingDecorator;
    }

    public void setBuildingDecorator(BuildingDecorator decorator, GMLBuilding ... buildings) {
        this.setBuildingDecorator(decorator, Arrays.asList(buildings));
    }

    public void setBuildingDecorator(BuildingDecorator decorator, Collection<? extends GMLBuilding> buildings) {
        for (GMLBuilding gMLBuilding : buildings) {
            this.buildingDecorators.put(gMLBuilding, decorator);
        }
    }

    public BuildingDecorator getBuildingDecorator(GMLBuilding building) {
        BuildingDecorator result = this.buildingDecorators.get(building);
        if (result == null) {
            result = this.defaultBuildingDecorator;
        }
        return result;
    }

    public void clearBuildingDecorator(GMLBuilding ... buildings) {
        this.clearBuildingDecorator(Arrays.asList(buildings));
    }

    public void clearBuildingDecorator(Collection<? extends GMLBuilding> buildings) {
        for (GMLBuilding gMLBuilding : buildings) {
            this.buildingDecorators.remove(gMLBuilding);
        }
    }

    public void clearAllBuildingDecorators() {
        this.buildingDecorators.clear();
    }

    public void setDefaultRoadDecorator(RoadDecorator defaultDecorator) {
        this.defaultRoadDecorator = defaultDecorator;
    }

    public RoadDecorator getDefaultRoadDecorator() {
        return this.defaultRoadDecorator;
    }

    public void setRoadDecorator(RoadDecorator decorator, GMLRoad ... roads) {
        this.setRoadDecorator(decorator, Arrays.asList(roads));
    }

    public void setRoadDecorator(RoadDecorator decorator, Collection<? extends GMLRoad> roads) {
        for (GMLRoad gMLRoad : roads) {
            this.roadDecorators.put(gMLRoad, decorator);
        }
    }

    public RoadDecorator getRoadDecorator(GMLRoad road) {
        RoadDecorator result = this.roadDecorators.get(road);
        if (result == null) {
            result = this.defaultRoadDecorator;
        }
        return result;
    }

    public void clearRoadDecorator(GMLRoad ... roads) {
        this.clearRoadDecorator(Arrays.asList(roads));
    }

    public void clearRoadDecorator(Collection<? extends GMLRoad> roads) {
        for (GMLRoad gMLRoad : roads) {
            this.roadDecorators.remove(gMLRoad);
        }
    }

    public void clearAllRoadDecorators() {
        this.roadDecorators.clear();
    }

    public void setDefaultSpaceDecorator(SpaceDecorator defaultDecorator) {
        this.defaultSpaceDecorator = defaultDecorator;
    }

    public SpaceDecorator getDefaultSpaceDecorator() {
        return this.defaultSpaceDecorator;
    }

    public void setSpaceDecorator(SpaceDecorator decorator, GMLSpace ... spaces) {
        this.setSpaceDecorator(decorator, Arrays.asList(spaces));
    }

    public void setSpaceDecorator(SpaceDecorator decorator, Collection<? extends GMLSpace> spaces) {
        for (GMLSpace gMLSpace : spaces) {
            this.spaceDecorators.put(gMLSpace, decorator);
        }
    }

    public SpaceDecorator getSpaceDecorator(GMLSpace space) {
        SpaceDecorator result = this.spaceDecorators.get(space);
        if (result == null) {
            result = this.defaultSpaceDecorator;
        }
        return result;
    }

    public void clearSpaceDecorator(GMLSpace ... spaces) {
        this.clearSpaceDecorator(Arrays.asList(spaces));
    }

    public void clearSpaceDecorator(Collection<? extends GMLSpace> spaces) {
        for (GMLSpace gMLSpace : spaces) {
            this.spaceDecorators.remove(gMLSpace);
        }
    }

    public void clearAllSpaceDecorators() {
        this.spaceDecorators.clear();
    }

    public void setGridEnabled(boolean b) {
        this.grid = b;
    }

    public void setGridResolution(double resolution) {
        this.gridResolution = resolution;
    }

    public void addOverlay(Overlay overlay) {
        this.overlays.add(overlay);
    }

    public void removeOverlay(Overlay overlay) {
        this.overlays.remove(overlay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics graphics) {
        Object d;
        HashSet<GMLNode> nodes;
        HashSet<GMLEdge> edges;
        HashSet<GMLSpace> spaces;
        HashSet<GMLBuilding> buildings;
        HashSet<GMLRoad> roads;
        super.paintComponent(graphics);
        Graphics copy = graphics.create();
        copy.setColor(this.getBackground());
        copy.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.map == null) {
            return;
        }
        Insets insets = this.getInsets();
        int width = this.getWidth() - insets.left - insets.right;
        int height = this.getHeight() - insets.top - insets.bottom;
        Graphics2D g = (Graphics2D)graphics.create(insets.left, insets.top, width + 1, height + 1);
        this.transform.rescale(width, height);
        GMLMap gMLMap = this.map;
        synchronized (gMLMap) {
            roads = new HashSet<GMLRoad>(this.map.getRoads());
            buildings = new HashSet<GMLBuilding>(this.map.getBuildings());
            spaces = new HashSet<GMLSpace>(this.map.getSpaces());
            edges = new HashSet<GMLEdge>(this.map.getEdges());
            nodes = new HashSet<GMLNode>(this.map.getNodes());
        }
        for (GMLRoad gMLRoad : roads) {
            d = this.getRoadDecorator(gMLRoad);
            if (d == null) continue;
            d.decorate(gMLRoad, (Graphics2D)g.create(), this.transform);
        }
        for (GMLBuilding gMLBuilding : buildings) {
            d = this.getBuildingDecorator(gMLBuilding);
            if (d == null) continue;
            d.decorate(gMLBuilding, (Graphics2D)g.create(), this.transform);
        }
        for (GMLSpace gMLSpace : spaces) {
            d = this.getSpaceDecorator(gMLSpace);
            if (d == null) continue;
            d.decorate(gMLSpace, (Graphics2D)g.create(), this.transform);
        }
        for (GMLEdge gMLEdge : edges) {
            EdgeDecorator e = this.getEdgeDecorator(gMLEdge);
            if (e == null) continue;
            e.decorate(gMLEdge, (Graphics2D)g.create(), this.transform);
        }
        for (GMLNode gMLNode : nodes) {
            NodeDecorator n = this.getNodeDecorator(gMLNode);
            if (n == null) continue;
            n.decorate(gMLNode, (Graphics2D)g.create(), this.transform);
        }
        for (Overlay overlay : this.overlays) {
            overlay.render((Graphics2D)g.create(), this.transform);
        }
        if (this.grid) {
            double xMin = this.roundDownToGrid(this.transform.screenToX(0));
            double xMax = this.roundUpToGrid(this.transform.screenToX(width));
            double yMin = this.roundDownToGrid(this.transform.screenToY(height));
            double yMax = this.roundUpToGrid(this.transform.screenToY(0));
            g.setColor(GRID_COLOUR);
            for (double worldX = xMin; worldX <= xMax; worldX += this.gridResolution) {
                int x = this.transform.xToScreen(worldX);
                g.drawLine(x, 0, x, height);
            }
            for (double worldY = yMin; worldY <= yMax; worldY += this.gridResolution) {
                int y = this.transform.yToScreen(worldY);
                g.drawLine(0, y, width, y);
            }
        }
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    public void setPanZoomEnabled(boolean enabled) {
        this.panZoom.setEnabled(enabled);
    }

    public GMLCoordinates getCoordinatesAtPoint(int x, int y) {
        double cx = this.transform.screenToX(x);
        double cy = this.transform.screenToY(y);
        return new GMLCoordinates(cx, cy);
    }

    public Point getScreenCoordinates(GMLCoordinates c) {
        int x = this.transform.xToScreen(c.getX());
        int y = this.transform.yToScreen(c.getY());
        return new Point(x, y);
    }

    private double roundDownToGrid(double d) {
        return Math.floor(d / this.gridResolution) * this.gridResolution;
    }

    private double roundUpToGrid(double d) {
        return Math.ceil(d / this.gridResolution) * this.gridResolution;
    }
}

