/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.generator;

import java.io.File;
import maps.Map;
import maps.MapException;
import maps.MapFormat;
import maps.MapWriter;
import maps.gml.GMLMap;
import maps.gml.formats.RobocupFormat;
import maps.gml.generator.ManhattanGenerator;
import rescuecore2.config.Config;
import rescuecore2.config.ConfigException;
import rescuecore2.log.Logger;

public class GMLMapGenerator {
    private static final String OUTPUT_FILE_KEY = "generator.output";
    private Config config;

    public GMLMapGenerator(Config config) {
        this.config = config;
    }

    public static void main(String[] args) {
        try {
            Config config = new Config();
            for (int i = 0; i < args.length; ++i) {
                config.read(new File(args[i]));
            }
            GMLMap map = new GMLMapGenerator(config).generateMap();
            String outFile = config.getValue(OUTPUT_FILE_KEY);
            Logger.debug((String)("Writing generated map to " + outFile));
            MapWriter.writeMap((Map)map, outFile, (MapFormat)RobocupFormat.INSTANCE);
        }
        catch (MapException e) {
            e.printStackTrace();
        }
        catch (ConfigException e) {
            e.printStackTrace();
        }
    }

    public GMLMap generateMap() {
        GMLMap result = new GMLMap();
        new ManhattanGenerator(this.config).populate(result);
        return result;
    }
}

