/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.editor;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import maps.gml.GMLEdge;
import maps.gml.GMLMap;
import maps.gml.GMLNode;
import maps.gml.GMLTools;
import maps.gml.editor.GMLEditor;
import maps.gml.editor.ProgressFunction;
import rescuecore2.log.Logger;
import rescuecore2.misc.geometry.GeometryTools2D;
import rescuecore2.misc.geometry.Line2D;
import rescuecore2.misc.geometry.Point2D;

public class SplitEdgesFunction
extends ProgressFunction {
    private static final double DEFAULT_THRESHOLD = 0.001;
    private double threshold;

    public SplitEdgesFunction(GMLEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Split edges";
    }

    @Override
    public void execute() {
        String s = JOptionPane.showInputDialog(this.editor.getViewer(), "Enter the desired distance threshold (in m)", 0.001);
        if (s == null) {
            return;
        }
        this.threshold = Double.parseDouble(s);
        super.execute();
    }

    @Override
    protected String getTitle() {
        return "Splitting edges";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeImpl() {
        LinkedList<GMLEdge> remaining = new LinkedList<GMLEdge>();
        HashSet<GMLNode> nodes = new HashSet<GMLNode>();
        GMLMap gMLMap = this.editor.getMap();
        synchronized (gMLMap) {
            remaining.addAll(this.editor.getMap().getEdges());
            nodes.addAll(this.editor.getMap().getNodes());
        }
        this.setProgressLimit(remaining.size());
        int count = 0;
        while (!remaining.isEmpty()) {
            GMLEdge next = (GMLEdge)remaining.remove();
            Line2D line = GMLTools.toLine(next);
            for (GMLNode node : nodes) {
                Collection<GMLEdge> newEdges;
                Point2D closest;
                Point2D p;
                if (node == next.getStart() || node == next.getEnd() || !(GeometryTools2D.getDistance((Point2D)(p = GMLTools.toPoint(node)), (Point2D)(closest = GeometryTools2D.getClosestPointOnSegment((Line2D)line, (Point2D)p))) < this.threshold)) continue;
                GMLMap gMLMap2 = this.editor.getMap();
                synchronized (gMLMap2) {
                    newEdges = this.editor.getMap().splitEdge(next, node);
                    this.editor.getMap().removeEdge(next);
                    newEdges.removeAll(this.editor.getMap().getEdges());
                }
                remaining.addAll(newEdges);
                this.bumpMaxProgress(newEdges.size());
                ++count;
                break;
            }
            this.bumpProgress();
        }
        if (count != 0) {
            this.editor.setChanged();
            this.editor.getViewer().repaint();
        }
        Logger.debug((String)("Split " + count + " edges"));
    }
}

