/*
 * Decompiled with CFR 0.152.
 */
package maps.gml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import maps.Map;
import maps.MapException;
import maps.MapFormat;
import maps.gml.GMLMap;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import rescuecore2.log.Logger;

public abstract class GMLMapFormat
implements MapFormat {
    @Override
    public GMLMap read(File file) throws MapException {
        FileReader r;
        try {
            r = new FileReader(file);
        }
        catch (FileNotFoundException e) {
            throw new MapException(e);
        }
        try {
            GMLMap e = this.read(r);
            return e;
        }
        catch (DocumentException e) {
            throw new MapException(e);
        }
        finally {
            try {
                r.close();
            }
            catch (IOException e) {
                Logger.warn((String)"IOException while closing file reader", (Throwable)e);
            }
        }
    }

    @Override
    public void write(Map map, File file) throws MapException {
        if (map == null) {
            throw new IllegalArgumentException("Map must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("File must not be null");
        }
        if (!(map instanceof GMLMap)) {
            throw new IllegalArgumentException("Map is not a GMLMap: " + map.getClass().getName());
        }
        Document doc = this.write((GMLMap)map);
        try {
            if (!file.exists()) {
                File parent = file.getParentFile();
                if (!parent.exists() && !file.getParentFile().mkdirs()) {
                    throw new MapException("Couldn't create file " + file.getPath());
                }
                if (!file.createNewFile()) {
                    throw new MapException("Couldn't create file " + file.getPath());
                }
            }
            XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(file), OutputFormat.createPrettyPrint());
            Element root = doc.getRootElement();
            for (Map.Entry<String, String> next : this.getNamespaces().entrySet()) {
                root.addNamespace(next.getKey(), next.getValue());
            }
            writer.write(doc);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            throw new MapException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canRead(File file) throws MapException {
        FileReader r;
        if (file.isDirectory() || !file.exists()) {
            return false;
        }
        if (!file.getName().endsWith(".gml")) {
            return false;
        }
        try {
            r = new FileReader(file);
        }
        catch (FileNotFoundException e) {
            throw new MapException(e);
        }
        try {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(r);
            while (reader.hasNext()) {
                if (reader.next() != 1) continue;
                boolean bl = this.isCorrectRootElement(reader.getNamespaceURI(), reader.getLocalName());
                return bl;
            }
        }
        catch (XMLStreamException e) {
            Logger.debug((String)"Exception while reading XML stream", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                r.close();
            }
            catch (IOException e) {
                Logger.warn((String)"IOException while closing file reader", (Throwable)e);
            }
        }
        return false;
    }

    public GMLMap read(Reader reader) throws DocumentException, MapException {
        Logger.debug((String)"Parsing GML");
        SAXReader saxReader = new SAXReader();
        Document doc = saxReader.read(reader);
        Logger.debug((String)"Building map");
        return this.read(doc);
    }

    protected abstract boolean isCorrectRootElement(String var1, String var2);

    protected abstract GMLMap read(Document var1) throws MapException;

    protected abstract Document write(GMLMap var1);

    protected abstract java.util.Map<String, String> getNamespaces();
}

