/*
 * Decompiled with CFR 0.152.
 */
package maps.convert.osm2gml.buildings;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Random;
import maps.convert.osm2gml.buildings.BuildingSpaceFiller;
import maps.convert.osm2gml.buildings.row.RectangularDuplexRowFiller;
import maps.convert.osm2gml.buildings.row.RowFiller;
import maps.gml.GMLDirectedEdge;
import maps.gml.GMLMap;
import maps.gml.GMLNode;
import maps.gml.GMLShape;

public class RowHousingBuildingSpaceFiller
implements BuildingSpaceFiller {
    private double sizeOf1m;
    private Random random;

    public RowHousingBuildingSpaceFiller(double sizeOf1m, Random random) {
        this.sizeOf1m = sizeOf1m;
        this.random = random;
    }

    @Override
    public void createBuildings(GMLShape space, GMLMap map) {
    }

    private RowFiller createRandomFiller() {
        if (this.random.nextBoolean()) {
            return RectangularDuplexRowFiller.makeWideFiller(this.sizeOf1m, this.random);
        }
        return RectangularDuplexRowFiller.makeLongFiller(this.sizeOf1m, this.random);
    }

    private static final class EdgeLengthComparator
    implements Comparator<GMLDirectedEdge>,
    Serializable {
        private EdgeLengthComparator() {
        }

        @Override
        public int compare(GMLDirectedEdge e1, GMLDirectedEdge e2) {
            double l2;
            GMLNode start1 = e1.getStartNode();
            GMLNode end1 = e1.getEndNode();
            GMLNode start2 = e2.getStartNode();
            GMLNode end2 = e2.getEndNode();
            double dx1 = end1.getX() - start1.getX();
            double dy1 = end1.getY() - start1.getY();
            double dx2 = end2.getX() - start2.getX();
            double dy2 = end2.getY() - start2.getY();
            double l1 = Math.hypot(dx1, dy1);
            if (l1 < (l2 = Math.hypot(dx2, dy2))) {
                return 1;
            }
            if (l2 < l1) {
                return -1;
            }
            return 0;
        }
    }
}

