/*
 * Decompiled with CFR 0.152.
 */
package maps.convert.osm2gml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import maps.convert.ConvertStep;
import maps.convert.osm2gml.DirectedEdge;
import maps.convert.osm2gml.Node;
import maps.convert.osm2gml.OSMBuildingInfo;
import maps.convert.osm2gml.OSMIntersectionInfo;
import maps.convert.osm2gml.OSMRoadInfo;
import maps.convert.osm2gml.OSMShape;
import maps.convert.osm2gml.TemporaryBuilding;
import maps.convert.osm2gml.TemporaryIntersection;
import maps.convert.osm2gml.TemporaryMap;
import maps.convert.osm2gml.TemporaryRoad;
import rescuecore2.misc.geometry.Point2D;

public class MakeTempObjectsStep
extends ConvertStep {
    private TemporaryMap map;

    public MakeTempObjectsStep(TemporaryMap map) {
        this.map = map;
    }

    @Override
    public String getDescription() {
        return "Generating temporary objects";
    }

    @Override
    protected void step() {
        Collection<OSMRoadInfo> roads = this.map.getOSMRoadInfo();
        Collection<OSMIntersectionInfo> intersections = this.map.getOSMIntersectionInfo();
        Collection<OSMBuildingInfo> buildings = this.map.getOSMBuildingInfo();
        this.setProgressLimit(roads.size() + intersections.size() + buildings.size());
        this.generateRoadObjects(roads);
        this.generateIntersectionObjects(intersections);
        this.generateBuildingObjects(buildings);
        this.setStatus("Created " + this.map.getRoads().size() + " roads, " + this.map.getIntersections().size() + " intersections, " + this.map.getBuildings().size() + " buildings");
    }

    private void generateRoadObjects(Collection<OSMRoadInfo> roads) {
        for (OSMRoadInfo road : roads) {
            List<DirectedEdge> edges;
            if (road.getArea() != null && (edges = this.generateEdges(road)).size() > 2) {
                this.map.addRoad(new TemporaryRoad(edges));
            }
            this.bumpProgress();
        }
    }

    private void generateIntersectionObjects(Collection<OSMIntersectionInfo> intersections) {
        for (OSMIntersectionInfo intersection : intersections) {
            List<DirectedEdge> edges;
            if (intersection.getArea() != null && (edges = this.generateEdges(intersection)).size() > 2) {
                this.map.addIntersection(new TemporaryIntersection(edges));
            }
            this.bumpProgress();
        }
    }

    private void generateBuildingObjects(Collection<OSMBuildingInfo> buildings) {
        for (OSMBuildingInfo building : buildings) {
            List<DirectedEdge> edges;
            if (building.getArea() != null && (edges = this.generateEdges(building)).size() > 2) {
                this.map.addBuilding(new TemporaryBuilding(edges, building.getBuildingID()));
            }
            this.bumpProgress();
        }
    }

    private List<DirectedEdge> generateEdges(OSMShape s) {
        Node first;
        ArrayList<DirectedEdge> result = new ArrayList<DirectedEdge>();
        Iterator<Point2D> it = s.getVertices().iterator();
        Node previous = first = this.map.getNode(it.next());
        while (it.hasNext()) {
            Node n = this.map.getNode(it.next());
            if (n.equals(previous)) continue;
            result.add(this.map.getDirectedEdge(previous, n));
            previous = n;
        }
        if (!previous.equals(first)) {
            result.add(this.map.getDirectedEdge(previous, first));
        }
        return result;
    }
}

