/*
 * Decompiled with CFR 0.152.
 */
package ignition;

import ignition.IgnitionModel;
import ignition.RandomIgnitionModel;
import java.util.Set;
import rescuecore2.log.Logger;
import rescuecore2.messages.control.KSCommands;
import rescuecore2.standard.components.StandardSimulator;
import rescuecore2.standard.entities.Building;
import rescuecore2.standard.entities.StandardWorldModel;
import rescuecore2.worldmodel.ChangeSet;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.Property;

public class IgnitionSimulator
extends StandardSimulator {
    private IgnitionModel ignitionModel;

    protected void postConnect() {
        super.postConnect();
        this.ignitionModel = new RandomIgnitionModel((StandardWorldModel)this.model, this.config);
    }

    protected void processCommands(KSCommands c, ChangeSet changes) {
        long start = System.currentTimeMillis();
        int time = c.getTime();
        Logger.info((String)("Timestep " + time));
        Set<Building> buildings = this.ignitionModel.findIgnitionPoints((StandardWorldModel)this.model, c.getTime());
        for (Building next : buildings) {
            Logger.info((String)("Igniting " + next));
            next.setIgnition(true);
            changes.addChange((Entity)next, (Property)next.getIgnitionProperty());
        }
        long end = System.currentTimeMillis();
        Logger.info((String)("Timestep " + time + " took " + (end - start) + " ms"));
    }

    public String getName() {
        return "Ignition simulator";
    }
}

