/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.nagoyau.is.ss.kishii.suntori.message;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.BaseMessageType;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.EntityIDComparator;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.RCRSCSMessage;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.data.DataType;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.data.EntityIDData;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.data.EntityIDListData;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.data.RCRSCSData;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.data.ValueData;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.information.AmbulanceTeamInformation;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.information.BlockadeInformation;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.information.BuildingInformation;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.information.FireBrigadeInformation;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.information.PoliceForceInformation;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.information.PositionInformation;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.information.TransferInformation;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.information.VictimInformation;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.task.MoveTaskMessage;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.task.MoveWithStagingPostTaskMessage;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.task.RestAtRefugeTaskMessage;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.task.RestTaskMessage;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.task.TaskMessage;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.task.at.RescueAreaTaskMessage;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.task.fb.ExtinguishAreaTaskMessage;
import jp.ac.nagoyau.is.ss.kishii.suntori.message.task.pf.ClearRouteTaskMessage;
import rescuecore2.config.Config;
import rescuecore2.standard.entities.AmbulanceCentre;
import rescuecore2.standard.entities.AmbulanceTeam;
import rescuecore2.standard.entities.FireBrigade;
import rescuecore2.standard.entities.FireStation;
import rescuecore2.standard.entities.PoliceForce;
import rescuecore2.standard.entities.PoliceOffice;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardEntityConstants;
import rescuecore2.standard.entities.StandardEntityURN;
import rescuecore2.standard.entities.StandardWorldModel;
import rescuecore2.worldmodel.EntityID;

public class RCRSCSMessageConverter {
    private List<EntityID> buildingList;
    private List<EntityID> roadList;
    private List<EntityID> refugeList;
    private List<EntityID> areaList;
    private List<EntityID> policeForceList;
    private List<EntityID> ambulanceTeamList;
    private List<EntityID> fireBrigadeList;
    private List<EntityID> platoonAgentList;
    private List<EntityID> policeOfficeList;
    private List<EntityID> fireStationList;
    private List<EntityID> ambulanceCenterList;
    private List<EntityID> centerList;
    private List<EntityID> rescueList;
    private EntityID ownerID;
    private DataType agentType;
    private final int messageKind;
    private EnumMap<DataType, Integer> dataBitSizeMap;
    private EnumMap<BaseMessageType, Integer> messageMininumSizeMap;
    public final int EXTINGUISHABLE_POWER;
    public final int EXTINGUISHABLE_DISTANCE;
    public final int TANK_MAX;
    public final int HP_PERCEPTION_LOS;
    public final int DAMAGE_PERCEPTION_LOS;
    public final int RANGE_OF_VIEW;
    private static final boolean debug = false;

    public RCRSCSMessageConverter(EntityID ownerID, Config config, List<EntityID> buildingList, List<EntityID> roadList, List<EntityID> refugeList, List<EntityID> areaList, List<EntityID> policeForceList, List<EntityID> ambulanceTeamList, List<EntityID> fireBrigadeList, List<EntityID> platoonAgentList, List<EntityID> policeOfficeList, List<EntityID> ambulanceCenterList, List<EntityID> fireStationList) {
        this.ownerID = ownerID;
        this.buildingList = buildingList;
        this.roadList = roadList;
        this.refugeList = refugeList;
        this.areaList = areaList;
        this.policeForceList = policeForceList;
        this.ambulanceTeamList = ambulanceTeamList;
        this.fireBrigadeList = fireBrigadeList;
        this.platoonAgentList = platoonAgentList;
        this.policeOfficeList = policeOfficeList;
        this.ambulanceCenterList = ambulanceCenterList;
        this.fireStationList = fireStationList;
        this.centerList = new ArrayList<EntityID>();
        this.centerList.addAll(policeOfficeList);
        this.centerList.addAll(ambulanceCenterList);
        this.centerList.addAll(fireBrigadeList);
        this.rescueList = new ArrayList<EntityID>();
        this.rescueList.addAll(platoonAgentList);
        this.rescueList.addAll(this.centerList);
        EntityIDComparator comp = new EntityIDComparator();
        Collections.sort(this.centerList, comp);
        Collections.sort(this.rescueList, comp);
        this.checkAgentType();
        this.EXTINGUISHABLE_POWER = config.getIntValue("fire.extinguish.max-sum", 500);
        this.EXTINGUISHABLE_DISTANCE = config.getIntValue("fire.extinguish.max-distance", 50000);
        this.TANK_MAX = config.getIntValue("fire.tank.maximum", 7500);
        this.HP_PERCEPTION_LOS = config.getIntValue("perception.los.precision.hp", 1000);
        this.DAMAGE_PERCEPTION_LOS = config.getIntValue("perception.los.precision.damage", 100);
        this.RANGE_OF_VIEW = config.getIntValue("perception.los.max-distance", 30000);
        this.messageKind = this.calculateBitSize(BaseMessageType.values().length);
        this.initBitSizeMap(this.dataBitSizeMap);
        this.initMessageMinimunSizeMap();
    }

    public RCRSCSMessageConverter(EntityID ownerID, StandardWorldModel model, Config config) {
        this.ownerID = ownerID;
        this.checkAgentType((StandardEntity)model.getEntity(ownerID));
        EntityIDComparator comp = new EntityIDComparator();
        this.buildingList = this.getIDList(model, comp, StandardEntityURN.BUILDING, StandardEntityURN.REFUGE, StandardEntityURN.AMBULANCE_CENTRE, StandardEntityURN.FIRE_STATION, StandardEntityURN.POLICE_OFFICE);
        this.roadList = this.getIDList(model, comp, StandardEntityURN.ROAD);
        this.refugeList = this.getIDList(model, comp, StandardEntityURN.REFUGE);
        this.areaList = this.getIDList(model, comp, StandardEntityURN.ROAD, StandardEntityURN.BUILDING, StandardEntityURN.AMBULANCE_CENTRE, StandardEntityURN.FIRE_STATION, StandardEntityURN.POLICE_OFFICE, StandardEntityURN.REFUGE);
        this.policeForceList = this.getIDList(model, comp, StandardEntityURN.POLICE_FORCE);
        this.ambulanceTeamList = this.getIDList(model, comp, StandardEntityURN.AMBULANCE_TEAM);
        this.fireBrigadeList = this.getIDList(model, comp, StandardEntityURN.FIRE_BRIGADE);
        this.platoonAgentList = this.getIDList(model, comp, StandardEntityURN.POLICE_FORCE, StandardEntityURN.AMBULANCE_TEAM, StandardEntityURN.FIRE_BRIGADE);
        this.policeOfficeList = this.getIDList(model, comp, StandardEntityURN.POLICE_OFFICE);
        this.ambulanceCenterList = this.getIDList(model, comp, StandardEntityURN.AMBULANCE_CENTRE);
        this.fireStationList = this.getIDList(model, comp, StandardEntityURN.FIRE_STATION);
        this.centerList = this.getIDList(model, comp, StandardEntityURN.POLICE_OFFICE, StandardEntityURN.AMBULANCE_CENTRE, StandardEntityURN.FIRE_STATION);
        this.rescueList = this.getIDList(model, comp, StandardEntityURN.POLICE_FORCE, StandardEntityURN.AMBULANCE_TEAM, StandardEntityURN.FIRE_BRIGADE, StandardEntityURN.POLICE_OFFICE, StandardEntityURN.AMBULANCE_CENTRE, StandardEntityURN.FIRE_STATION);
        this.EXTINGUISHABLE_POWER = config.getIntValue("fire.extinguish.max-sum", 500);
        this.EXTINGUISHABLE_DISTANCE = config.getIntValue("fire.extinguish.max-distance", 50000);
        this.TANK_MAX = config.getIntValue("fire.tank.maximum", 7500);
        this.HP_PERCEPTION_LOS = config.getIntValue("perception.los.precision.hp", 1000);
        this.DAMAGE_PERCEPTION_LOS = config.getIntValue("perception.los.precision.damage", 100);
        this.RANGE_OF_VIEW = config.getIntValue("perception.los.max-distance", 30000);
        this.messageKind = this.calculateBitSize(BaseMessageType.values().length);
        this.initBitSizeMap(this.dataBitSizeMap);
        this.initMessageMinimunSizeMap();
    }

    private void checkAgentType() {
        this.agentType = DataType.HUMAN;
        if (this.ambulanceTeamList.contains(this.ownerID)) {
            this.agentType = DataType.AMBULANCE_TEAM;
        } else if (this.fireBrigadeList.contains(this.ownerID)) {
            this.agentType = DataType.FIRE_BRIGADE;
        } else if (this.policeForceList.contains(this.ownerID)) {
            this.agentType = DataType.POLICE_FORCE;
        } else if (this.ambulanceCenterList.contains(this.ownerID)) {
            this.agentType = DataType.AMBULANCE_CENTER;
        } else if (this.fireStationList.contains(this.ownerID)) {
            this.agentType = DataType.FIRE_STATION;
        } else if (this.policeOfficeList.contains(this.ownerID)) {
            this.agentType = DataType.POLICE_OFFICE;
        }
    }

    private DataType getAgentType(EntityID id) {
        DataType res = null;
        if (this.ambulanceTeamList.contains(id)) {
            res = DataType.AMBULANCE_TEAM;
        } else if (this.fireBrigadeList.contains(id)) {
            res = DataType.FIRE_BRIGADE;
        } else if (this.policeForceList.contains(id)) {
            res = DataType.POLICE_FORCE;
        } else if (this.ambulanceCenterList.contains(id)) {
            res = DataType.AMBULANCE_CENTER;
        } else if (this.fireStationList.contains(id)) {
            res = DataType.FIRE_STATION;
        } else if (this.policeOfficeList.contains(id)) {
            res = DataType.POLICE_OFFICE;
        }
        return res;
    }

    private boolean isCenter(EntityID id) {
        return this.centerList.contains(id);
    }

    private boolean isPlatoon(EntityID id) {
        return this.platoonAgentList.contains(id);
    }

    private boolean isBelong(DataType center, DataType agent) {
        boolean res = false;
        if (agent.equals((Object)DataType.AMBULANCE_TEAM) && center.equals((Object)DataType.AMBULANCE_CENTER)) {
            res = true;
        } else if (agent.equals((Object)DataType.FIRE_BRIGADE) && center.equals((Object)DataType.FIRE_STATION)) {
            res = true;
        } else if (agent.equals((Object)DataType.POLICE_FORCE) && center.equals((Object)DataType.POLICE_OFFICE)) {
            res = true;
        }
        return res;
    }

    private void checkAgentType(StandardEntity se) {
        this.agentType = DataType.HUMAN;
        if (se instanceof AmbulanceTeam) {
            this.agentType = DataType.AMBULANCE_TEAM;
        } else if (se instanceof FireBrigade) {
            this.agentType = DataType.FIRE_BRIGADE;
        } else if (se instanceof PoliceForce) {
            this.agentType = DataType.POLICE_FORCE;
        } else if (se instanceof AmbulanceCentre) {
            this.agentType = DataType.AMBULANCE_CENTER;
        } else if (se instanceof FireStation) {
            this.agentType = DataType.FIRE_STATION;
        } else if (se instanceof PoliceOffice) {
            this.agentType = DataType.POLICE_OFFICE;
        }
    }

    private void initMessageMinimunSizeMap() {
        this.messageMininumSizeMap = new EnumMap(BaseMessageType.class);
        BaseMessageType[] baseMessageTypeArray = BaseMessageType.values();
        int n = baseMessageTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            BaseMessageType type = baseMessageTypeArray[n2];
            this.messageMininumSizeMap.put(type, this.messageMinimumBitSize(type));
            ++n2;
        }
    }

    private int messageMinimumBitSize(BaseMessageType m) {
        DataType dt;
        int res = 0;
        DataType[] dataTypeArray = RCRSCSMessage.COMMON_DATA_TYPE;
        int n = RCRSCSMessage.COMMON_DATA_TYPE.length;
        int n2 = 0;
        while (n2 < n) {
            dt = dataTypeArray[n2];
            res += this.dataBitSizeMap.get((Object)dt).intValue();
            ++n2;
        }
        dataTypeArray = m.getDataType();
        n = dataTypeArray.length;
        n2 = 0;
        while (n2 < n) {
            dt = dataTypeArray[n2];
            res = dt == DataType.ID_LIST || dt == DataType.AREA_LIST ? (res += 32) : (res += this.dataBitSizeMap.get((Object)dt).intValue());
            ++n2;
        }
        return res;
    }

    private void initBitSizeMap(EnumMap<DataType, Integer> map) {
        this.dataBitSizeMap = new EnumMap(DataType.class);
        this.dataBitSizeMap.put(DataType.TIME, this.calculateBitSize(1000));
        this.dataBitSizeMap.put(DataType.X_COORDINATE, 32);
        this.dataBitSizeMap.put(DataType.Y_COORDINATE, 32);
        this.dataBitSizeMap.put(DataType.AREA, this.calculateBitSize(this.areaList.size()));
        this.dataBitSizeMap.put(DataType.ROAD, this.calculateBitSize(this.roadList.size()));
        this.dataBitSizeMap.put(DataType.BUILDING, this.calculateBitSize(this.buildingList.size()));
        this.dataBitSizeMap.put(DataType.REFUGE, this.calculateBitSize(this.refugeList.size()));
        this.dataBitSizeMap.put(DataType.BLOCKADE, 32);
        this.dataBitSizeMap.put(DataType.HUMAN, 32);
        this.dataBitSizeMap.put(DataType.FIRE_BRIGADE, this.calculateBitSize(this.fireBrigadeList.size()));
        this.dataBitSizeMap.put(DataType.AMBULANCE_TEAM, this.calculateBitSize(this.ambulanceTeamList.size()));
        this.dataBitSizeMap.put(DataType.POLICE_FORCE, this.calculateBitSize(this.policeForceList.size()));
        this.dataBitSizeMap.put(DataType.PLATOON_AGENT, this.calculateBitSize(this.platoonAgentList.size()));
        this.dataBitSizeMap.put(DataType.CENTER_AGENT, this.calculateBitSize(this.centerList.size()));
        this.dataBitSizeMap.put(DataType.RESCUE_AGENT, this.calculateBitSize(this.rescueList.size()));
        this.dataBitSizeMap.put(DataType.HP, this.calculateBitSize(10000 / this.HP_PERCEPTION_LOS + 1));
        this.dataBitSizeMap.put(DataType.DAMAGE, this.calculateBitSize(10000 / this.DAMAGE_PERCEPTION_LOS + 1));
        this.dataBitSizeMap.put(DataType.BURIEDNESS, this.calculateBitSize(200));
        this.dataBitSizeMap.put(DataType.BROKENNESS, this.calculateBitSize(200));
        this.dataBitSizeMap.put(DataType.FIERYNESS, this.calculateBitSize(StandardEntityConstants.Fieryness.values().length));
        this.dataBitSizeMap.put(DataType.REPAIR_COST, this.calculateBitSize(1000));
        this.dataBitSizeMap.put(DataType.SUPPLY_QUANTITY, this.calculateBitSize(this.TANK_MAX + 1));
        this.dataBitSizeMap.put(DataType.WATER_POWER, this.calculateBitSize(this.EXTINGUISHABLE_POWER));
        this.dataBitSizeMap.put(DataType.WATER, this.calculateBitSize(7500));
    }

    private List<EntityID> getIDList(StandardWorldModel model, EntityIDComparator comp, StandardEntityURN urn) {
        return this.toIDList(model.getEntitiesOfType(urn), comp);
    }

    private List<EntityID> getIDList(StandardWorldModel model, EntityIDComparator comp, StandardEntityURN ... urns) {
        return this.toIDList(model.getEntitiesOfType(urns), comp);
    }

    private List<EntityID> toIDList(Collection<StandardEntity> col, EntityIDComparator comp) {
        ArrayList<EntityID> res = new ArrayList<EntityID>();
        for (StandardEntity se : col) {
            res.add(se.getID());
        }
        Collections.sort(res, comp);
        return res;
    }

    public List<RCRSCSMessage> bytesToMessageList(byte[] bytes) {
        List<Integer> bitList = RCRSCSMessageConverter.toBit(bytes);
        return this.bitToMessages(bitList);
    }

    private List<RCRSCSMessage> bitToMessages(List<Integer> bitList) {
        TaskMessage task;
        ArrayList<RCRSCSMessage> res = new ArrayList<RCRSCSMessage>();
        ArrayList<TaskMessage> taskList = new ArrayList<TaskMessage>();
        int offset = 0;
        while (offset < bitList.size()) {
            try {
                if (bitList.size() <= offset + 7 || bitList.size() - offset < this.messageKind) break;
                BaseMessageType mType = null;
                int mTypeValue = RCRSCSMessageConverter.bitToInt(bitList, offset, this.messageKind);
                mType = BaseMessageType.values()[mTypeValue];
                if (bitList.size() < (offset += this.messageKind) + this.messageMinimumBitSize(mType)) break;
                RCRSCSMessage message = null;
                switch (mType) {
                    case BUILDING: {
                        message = new BuildingInformation(bitList, offset, this.dataBitSizeMap);
                        break;
                    }
                    case BLOCKADE: 
                    case BLOCKADE_WITH_COORDINATE: {
                        message = new BlockadeInformation(mType, bitList, offset, this.dataBitSizeMap);
                        break;
                    }
                    case VICTIM: 
                    case VICTIM_WITH_COORDINATE: {
                        message = new VictimInformation(mType, bitList, offset, this.dataBitSizeMap);
                        break;
                    }
                    case POSITION: {
                        message = new PositionInformation(bitList, offset, this.dataBitSizeMap);
                        break;
                    }
                    case TRANSFER_PATHWAY: {
                        message = new TransferInformation(bitList, offset, this.dataBitSizeMap);
                        break;
                    }
                    case FIRE_BRIGADE: {
                        message = new FireBrigadeInformation(bitList, offset, this.dataBitSizeMap);
                        break;
                    }
                    case POLICE_FORCE: {
                        message = new PoliceForceInformation(bitList, offset, this.dataBitSizeMap);
                        break;
                    }
                    case AMBULANCE_TEAM: {
                        message = new AmbulanceTeamInformation(bitList, offset, this.dataBitSizeMap);
                        break;
                    }
                    case REST_TASK: {
                        message = new RestTaskMessage(bitList, offset, this.dataBitSizeMap);
                        break;
                    }
                    case REST_AT_REFUGE_TASK: {
                        message = new RestAtRefugeTaskMessage(bitList, offset, this.dataBitSizeMap);
                        break;
                    }
                    case MOVE_TASK: {
                        message = new MoveTaskMessage(bitList, offset, this.dataBitSizeMap);
                        break;
                    }
                    case MOVE_WITH_STAGING_POST_TASK: {
                        message = new MoveWithStagingPostTaskMessage(bitList, offset, this.dataBitSizeMap);
                        break;
                    }
                    case CLEAR_ROUTE: {
                        message = new ClearRouteTaskMessage(bitList, offset, this.dataBitSizeMap);
                        break;
                    }
                    case RESCUE_AREA: {
                        message = new RescueAreaTaskMessage(bitList, offset, this.dataBitSizeMap);
                        break;
                    }
                    case EXTINGUISH_AREA: {
                        message = new ExtinguishAreaTaskMessage(bitList, offset, this.dataBitSizeMap);
                        break;
                    }
                    default: {
                        throw new Exception("undefined message type " + (Object)((Object)mType) + "\n" + "decode was stopped on the way...");
                    }
                }
                offset += message.getMessageBitSize(this.dataBitSizeMap);
                EnumMap<DataType, Integer> counter = new EnumMap<DataType, Integer>(DataType.class);
                DataType[] dataTypeArray = message.getDataTypeArray();
                int n = dataTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DataType dt = dataTypeArray[n2];
                    int i = RCRSCSMessageConverter.getDataTypeIndex(counter, dt, 1);
                    RCRSCSData<?> messageData = message.getData(dt, i);
                    this.convertToRealData(messageData);
                    ++n2;
                }
                if (message instanceof TaskMessage) {
                    TaskMessage task2 = (TaskMessage)message;
                    if (!task2.getAssignedAgentID().equals((Object)this.ownerID)) continue;
                    taskList.add(task2);
                    continue;
                }
                res.add(message);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("This exception caused by message decoding step");
                break;
            }
        }
        if ((task = this.filteringTask(taskList)) != null) {
            res.add(task);
        }
        return res;
    }

    private TaskMessage filteringTask(List<TaskMessage> taskList) {
        TaskMessage res = null;
        DataType currentType = null;
        for (TaskMessage task : taskList) {
            EntityID id = task.getMessageOwnerID();
            DataType type = this.getAgentType(id);
            if (type == null) continue;
            if (this.isCenter(id)) {
                if (this.isBelong(type, this.agentType)) {
                    res = task;
                    break;
                }
                if (res != null && currentType != null && currentType.equals((Object)DataType.CENTER_AGENT)) continue;
                res = task;
                currentType = DataType.CENTER_AGENT;
                continue;
            }
            if (this.agentType.equals((Object)type) && currentType != null && !this.agentType.equals((Object)currentType)) {
                res = task;
                currentType = type;
                continue;
            }
            if (res != null) continue;
            res = task;
            currentType = type;
        }
        return res;
    }

    private void convertToRealData(RCRSCSData<?> messageData) {
        if (messageData instanceof EntityIDListData) {
            ArrayList<EntityID> ids = new ArrayList<EntityID>();
            switch (messageData.getType()) {
                case AREA_LIST: {
                    for (EntityID id : (List)((EntityIDListData)messageData).getData()) {
                        ids.add(this.areaList.get(id.getValue()));
                    }
                    ((EntityIDListData)messageData).setData((List<EntityID>)ids);
                }
            }
        } else {
            switch (messageData.getType()) {
                case AMBULANCE_TEAM: {
                    ((EntityIDData)messageData).setData(this.ambulanceTeamList.get(((EntityID)messageData.getData()).getValue()));
                    break;
                }
                case FIRE_BRIGADE: {
                    ((EntityIDData)messageData).setData(this.fireBrigadeList.get(((EntityID)messageData.getData()).getValue()));
                    break;
                }
                case POLICE_FORCE: {
                    ((EntityIDData)messageData).setData(this.policeForceList.get(((EntityID)messageData.getData()).getValue()));
                    break;
                }
                case PLATOON_AGENT: {
                    ((EntityIDData)messageData).setData(this.platoonAgentList.get(((EntityID)messageData.getData()).getValue()));
                    break;
                }
                case CENTER_AGENT: {
                    ((EntityIDData)messageData).setData(this.centerList.get(((EntityID)messageData.getData()).getValue()));
                    break;
                }
                case RESCUE_AGENT: {
                    ((EntityIDData)messageData).setData(this.rescueList.get(((EntityID)messageData.getData()).getValue()));
                    break;
                }
                case AREA: {
                    ((EntityIDData)messageData).setData(this.areaList.get(((EntityID)messageData.getData()).getValue()));
                    break;
                }
                case ROAD: {
                    ((EntityIDData)messageData).setData(this.roadList.get(((EntityID)messageData.getData()).getValue()));
                    break;
                }
                case BUILDING: {
                    ((EntityIDData)messageData).setData(this.buildingList.get(((EntityID)messageData.getData()).getValue()));
                    break;
                }
                case REFUGE: {
                    ((EntityIDData)messageData).setData(this.refugeList.get(((EntityID)messageData.getData()).getValue()));
                    break;
                }
                case HP: {
                    ((ValueData)messageData).setData((Integer)((ValueData)messageData).getData() * this.HP_PERCEPTION_LOS);
                    break;
                }
                case DAMAGE: {
                    ((ValueData)messageData).setData((Integer)((ValueData)messageData).getData() * this.DAMAGE_PERCEPTION_LOS);
                    break;
                }
                case TIME: 
                case X_COORDINATE: 
                case Y_COORDINATE: 
                case BLOCKADE: 
                case HUMAN: 
                case BURIEDNESS: 
                case FIERYNESS: 
                case WATER_POWER: 
                case SUPPLY_QUANTITY: 
                case REPAIR_COST: 
                case BROKENNESS: 
                case WATER: {
                    break;
                }
                default: {
                    System.err.println("undefined data type:" + (Object)((Object)messageData.getType()));
                }
            }
        }
    }

    public static int bitToInt(List<Integer> list, int index, int length) {
        int res = 0;
        try {
            int i = index;
            while (i < index + length) {
                res = res << 1 | list.get(i);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(String.valueOf(list.size()) + " " + index + " " + length);
            System.exit(-1);
        }
        return res;
    }

    private static List<Integer> toBit(byte[] bytes) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            res.addAll(RCRSCSMessageConverter.toBit(b, 8));
            ++n2;
        }
        return res;
    }

    public byte[] messageToBytes(List<RCRSCSMessage> messages) {
        byte[] res = null;
        if (messages.size() > 0) {
            ArrayList<Integer> bitList = new ArrayList<Integer>();
            for (RCRSCSMessage m : messages) {
                bitList.addAll(this.messageToBit(m));
            }
            messages.clear();
            res = this.getBytes(bitList);
        }
        return res;
    }

    private byte[] getBytes(List<Integer> bitList) {
        int index = 0;
        int offset = 7;
        byte[] res = new byte[(bitList.size() - 1) / 8 + 1];
        for (int bit : bitList) {
            int n = index++;
            res[n] = (byte)(res[n] | bit << offset);
            if ((offset = (offset + 7) % 8) != 7) continue;
        }
        return res;
    }

    private List<Integer> messageToBit(RCRSCSMessage message) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        EnumMap<DataType, Integer> counter = new EnumMap<DataType, Integer>(DataType.class);
        try {
            res.addAll(RCRSCSMessageConverter.toBit(message.getMessageType().ordinal(), this.messageKind));
            DataType[] dataTypeArray = message.getDataTypeArray();
            int n = dataTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataType dt = dataTypeArray[n2];
                int index = RCRSCSMessageConverter.getDataTypeIndex(counter, dt, 1);
                RCRSCSData<?> data = message.getData(dt, index);
                if (data instanceof EntityIDListData) {
                    List<Integer> values = this.convertToMessageValue((EntityIDListData)data);
                    int bitLength = 32;
                    if (dt == DataType.AREA_LIST) {
                        bitLength = this.dataBitSizeMap.get((Object)DataType.AREA);
                    }
                    res.addAll(RCRSCSMessageConverter.toBit(values.get(0), 32));
                    int i = 1;
                    while (i < values.size()) {
                        res.addAll(RCRSCSMessageConverter.toBit(values.get(i), bitLength));
                        ++i;
                    }
                } else {
                    res.addAll(RCRSCSMessageConverter.toBit(this.convertToMessageValue(data), this.dataBitSizeMap.get((Object)dt)));
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("This message will not be sended." + (Object)((Object)message.getMessageType()));
            res.clear();
        }
        return res;
    }

    private static List<Integer> toBit(int value, int length) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        int i = 0;
        while (i < length) {
            res.add(value >> i & 1);
            ++i;
        }
        Collections.reverse(res);
        return res;
    }

    private List<Integer> convertToMessageValue(EntityIDListData data) throws Exception {
        ArrayList<Integer> res;
        block8: {
            res = new ArrayList<Integer>();
            try {
                List ids = (List)data.getData();
                if (ids.size() <= 0) break block8;
                res.add(ids.size());
                switch (data.getType()) {
                    case ID_LIST: {
                        for (EntityID id : ids) {
                            int val = id.getValue();
                            res.add(val);
                        }
                        break;
                    }
                    case AREA_LIST: {
                        for (EntityID id : ids) {
                            int index = this.areaList.indexOf(id);
                            res.add(index);
                        }
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new Exception();
            }
        }
        return res;
    }

    private int convertToMessageValue(RCRSCSData<?> data) throws Exception {
        int res = -1;
        try {
            switch (data.getType()) {
                case AMBULANCE_TEAM: {
                    res = this.ambulanceTeamList.indexOf((EntityID)data.getData());
                    break;
                }
                case FIRE_BRIGADE: {
                    res = this.fireBrigadeList.indexOf((EntityID)data.getData());
                    break;
                }
                case POLICE_FORCE: {
                    res = this.policeForceList.indexOf((EntityID)data.getData());
                    break;
                }
                case PLATOON_AGENT: {
                    res = this.platoonAgentList.indexOf((EntityID)data.getData());
                    break;
                }
                case CENTER_AGENT: {
                    res = this.centerList.indexOf((EntityID)data.getData());
                    break;
                }
                case RESCUE_AGENT: {
                    res = this.rescueList.indexOf((EntityID)data.getData());
                    break;
                }
                case AREA: {
                    res = this.areaList.indexOf((EntityID)data.getData());
                    break;
                }
                case ROAD: {
                    res = this.roadList.indexOf((EntityID)data.getData());
                    break;
                }
                case BUILDING: {
                    res = this.buildingList.indexOf((EntityID)data.getData());
                    break;
                }
                case REFUGE: {
                    res = this.refugeList.indexOf((EntityID)data.getData());
                    break;
                }
                case HP: {
                    res = (Integer)data.getData() / this.HP_PERCEPTION_LOS;
                    break;
                }
                case DAMAGE: {
                    res = (Integer)data.getData() / this.DAMAGE_PERCEPTION_LOS;
                    break;
                }
                case BLOCKADE: 
                case HUMAN: {
                    res = ((EntityID)data.getData()).getValue();
                    break;
                }
                case TIME: 
                case X_COORDINATE: 
                case Y_COORDINATE: 
                case BURIEDNESS: 
                case FIERYNESS: 
                case WATER_POWER: 
                case SUPPLY_QUANTITY: 
                case REPAIR_COST: 
                case BROKENNESS: 
                case WATER: {
                    res = (Integer)data.getData();
                    break;
                }
                default: {
                    System.err.println("undefined data type:" + (Object)((Object)data.getType()));
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println((Object)data.getType());
            throw e;
        }
        return res;
    }

    public static int getDataTypeIndex(EnumMap<DataType, Integer> map, DataType dType, Integer i) {
        Integer val = map.get((Object)dType);
        val = val == null ? Integer.valueOf(0) : Integer.valueOf(val + i);
        map.put(dType, val);
        return val;
    }

    private int calculateBitSize(int value) {
        int res = 0;
        if (value == 1) {
            res = 1;
        } else if (value > 1) {
            res = (int)Math.ceil(Math.log10(value) / Math.log10(2.0));
        }
        return res;
    }
}

