# = String Test Case
#
#--
# Ruby version 1.8
#
# == Authors
# * Yomei Komiya
# 
# == Copyright
# 2008 the original author or authors.
#
# == License
# Apache License 2.0
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#  http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#++
# == Version
# SVN: $Id: string_test.rb 76 2008-10-12 11:45:33Z whitestar $
#
# == Since
# File available since Release 0.8.0

require 'commons/ruby/test/unit'

require 'commons/ruby/string'

class StringTest < Test::Unit::TestCase
      
  def setup
  end
      
      
  def teardown
  end


  def test_substring
    assert_equal('abcdef', 'abcdef'.substring(0))
    assert_equal('cdef',   'abcdef'.substring(2))
    assert_equal('f',      'abcdef'.substring(5))
    assert_equal('',       'abcdef'.substring(6))
    
    assert_equal('ab', 'abcdef'.substring(0, 2))
    assert_equal('c',  'abcdef'.substring(2, 3))
    assert_equal('de', 'abcdef'.substring(3, 5))
  end
  
  
  def test_replace_all
    assert_equal('aBcaBc', 'abcabc'.replace_all(/b/, 'B'))
    assert_equal('abcabc', 'abcabc'.replace_all(/z/, 'Z'))
  end

end
