# = Log Factory Test Case
# 
#--
# Ruby version 1.8
#
# == Authors
# * Yomei Komiya
# 
# == Copyright
# 2008 the original author or authors.
#
# == License
# Apache License 2.0
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#  http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#++
# == Version
# SVN: $Id: log_factory_test.rb 76 2008-10-12 11:45:33Z whitestar $
#
# == Since
# File available since Release 0.8.0

require 'commons/ruby/test/unit'

require 'commons/logging/log_factory'

module Commons
  module Logging

    class LogFactoryTest < Test::Unit::TestCase
      
      def setup
      end
      
      
      def teardown
      end
      
      
      def test_initialize
        # no test.
      end
      
      
      def test_get_factory
        assert_kind_of(LogFactory, LogFactory.get_factory)
      end
      
      
      def test_get_log
        log = LogFactory.get_log(self.class.name)
        
        e = Exception.new('exception message!')
        log.trace('trace message.') if log.trace?
        log.trace('trace message.', e) if log.trace?
        log.debug('debug message.') if log.debug?
        log.debug('debug message.', e) if log.debug?
        log.info('info message.') if log.info?
        log.info('info message.', e) if log.info?
        log.warn('warn message.') if log.warn?
        log.warn('warn message.', e) if log.warn?
        log.error('error message.') if log.error?
        log.error('error message.', e) if log.error?
        log.fatal('fatal message.') if log.fatal?
        log.fatal('fatal message.', e) if log.fatal?
      end
    end

  end
end