# = System Utilities
#
#--
# Ruby version 1.8
#
# == Authors
# * Yomei Komiya
# 
# == Copyright
# 2008 the original author or authors.
#
# == License
# Apache License 2.0
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#  http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#++
# == Version
# SVN: $Id: system_utils.rb 74 2008-10-12 02:17:15Z whitestar $
#
# == Since
# File available since Release 0.8.0

require 'facets/rbsystem'

module Commons
  module Lang
    
    class SystemUtils
      @@current_platform = nil
      
      @@line_separator = nil
      
      @@file_separator = nil
      
      @@path_separator = nil
      
      
      def initialize
        super()
      end
      
      
      def self.current_platform
        if @@current_platform == nil
          @@current_platform = System.current_platform
        end
        
        return @@current_platform
      end
      
      
      def self.line_separator
        if @@line_separator == nil
          if os_windows?
            @@line_separator = "\r\n"
          else
            @@line_separator = "\n"
          end
        end
        
        return @@line_separator
      end
      
      
      def self.file_separator
        if @@file_separator == nil
          if File::ALT_SEPARATOR == nil
            @@file_separator = File::SEPARATOR
          else
            @@file_separator = File::ALT_SEPARATOR
          end
=begin
          if os_windows?
            @@file_separator = '\\'
          else
            @@file_separator = '/'
          end
=end
        end
        
        return @@file_separator
      end
      
      
      def self.path_separator
        if @@path_separator == nil
          @@path_separator = File::PATH_SEPARATOR
        end
        
        return @@path_separator
      end
      
      
      def self.os_windows?
        return current_platform.include?('mswin32')
      end
      
      # TODO
  
    end
    
  end
end
