/**
 * <copyright>
 * </copyright>
 *
 * $Id: OPMLAdapterFactory.java,v 1.1 2005/03/08 17:30:54 mkamo Exp $
 */
package razgriz.news.model.opml.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;

import razgriz.news.model.opml.Body;
import razgriz.news.model.opml.Head;
import razgriz.news.model.opml.OPML;
import razgriz.news.model.opml.OPMLPackage;
import razgriz.news.model.opml.Outline;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see razgriz.news.model.opml.OPMLPackage
 * @generated
 */
public class OPMLAdapterFactory extends AdapterFactoryImpl {
    /**
     * The cached model package.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected static OPMLPackage modelPackage;

    /**
     * Creates an instance of the adapter factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public OPMLAdapterFactory() {
        if (modelPackage == null) {
            modelPackage = OPMLPackage.eINSTANCE;
        }
    }

    /**
     * Returns whether this factory is applicable for the type of the object.
     * <!-- begin-user-doc -->
     * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
     * <!-- end-user-doc -->
     * @return whether this factory is applicable for the type of the object.
     * @generated
     */
    public boolean isFactoryForType(Object object) {
        if (object == modelPackage) {
            return true;
        }
        if (object instanceof EObject) {
            return ((EObject)object).eClass().getEPackage() == modelPackage;
        }
        return false;
    }

    /**
     * The switch the delegates to the <code>createXXX</code> methods.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected OPMLSwitch modelSwitch =
        new OPMLSwitch() {
            public Object caseOutline(Outline object) {
                return createOutlineAdapter();
            }
            public Object caseOPML(OPML object) {
                return createOPMLAdapter();
            }
            public Object caseBody(Body object) {
                return createBodyAdapter();
            }
            public Object caseHead(Head object) {
                return createHeadAdapter();
            }
            public Object defaultCase(EObject object) {
                return createEObjectAdapter();
            }
        };

    /**
     * Creates an adapter for the <code>target</code>.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param target the object to adapt.
     * @return the adapter for the <code>target</code>.
     * @generated
     */
    public Adapter createAdapter(Notifier target) {
        return (Adapter)modelSwitch.doSwitch((EObject)target);
    }


    /**
     * Creates a new adapter for an object of class '{@link razgriz.news.model.opml.Outline <em>Outline</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see razgriz.news.model.opml.Outline
     * @generated
     */
    public Adapter createOutlineAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link razgriz.news.model.opml.OPML <em>OPML</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see razgriz.news.model.opml.OPML
     * @generated
     */
    public Adapter createOPMLAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link razgriz.news.model.opml.Body <em>Body</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see razgriz.news.model.opml.Body
     * @generated
     */
    public Adapter createBodyAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link razgriz.news.model.opml.Head <em>Head</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see razgriz.news.model.opml.Head
     * @generated
     */
    public Adapter createHeadAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for the default case.
     * <!-- begin-user-doc -->
     * This default implementation returns null.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @generated
     */
    public Adapter createEObjectAdapter() {
        return null;
    }

} //OPMLAdapterFactory
