/*
 * Created on 2005/01/21
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.common.text;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/**
 * 
 */
public class XMLFirstElementPicker {

    public XMLElement pick(URL url) {
        try {
            SAXParserFactory fact = SAXParserFactory.newInstance();
            SAXParser parser = fact.newSAXParser();

            PickHandler picker = new PickHandler();
            InputStream in = url.openStream();
            parser.parse(in, picker);

            in.close();

            return picker.getResult();
        } catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        } catch (ParserConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage());
        } catch (SAXException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public XMLElement pick(InputStream in) {
        try {
            SAXParserFactory fact = SAXParserFactory.newInstance();
            SAXParser parser = fact.newSAXParser();

            PickHandler picker = new PickHandler();
            parser.parse(in, picker);

            return picker.getResult();
        } catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        } catch (ParserConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage());
        } catch (SAXException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static class XMLElement {
        private String uri;
        private String localName;
        private String qName;
        private Attributes attributes;

        public XMLElement(
            String uri, String localName, String qName, Attributes attributes
        ) {
            this.uri = uri;
            this.localName = localName;
            this.qName = qName;
            this.attributes = attributes;
        }
        public Attributes getAttributes() {
            return attributes;
        }
        public String getLocalName() {
            return localName;
        }
        public String getQName() {
            return qName;
        }
        public String getUri() {
            return uri;
        }
    }
    
    private static class PickHandler extends DefaultHandler {
        private boolean done = false;
        private XMLElement result;

        public void startElement(
            String uri, String localName, String qName, Attributes attributes
        ) {
            if (!done) {
                result = new XMLElement(uri, localName, qName, attributes);
                done = true;
            }
        }

        public XMLElement getResult() {
            return result;
        }
    }
}
