/*
 * Created on 2005/02/28
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.ui.dialogs;

import java.util.Map;

import org.apache.commons.lang.StringUtils;

import razgriz.common.util.SortUtil;
import razgriz.news.ui.dialogs.BeanEditorDialog.PropertyDecorator;
import razgriz.news.ui.dialogs.BeanEditorDialog.PropertySorter;
import razgriz.news.ui.dialogs.BeanEditorDialog.PropertyValidator;

/**
 * 
 */
public class NewsDialogBean
    implements PropertyValidator, PropertyDecorator, PropertySorter {

    private String title;
    private String link;
    private String description;

    public String getTitle() {
        return title;
    }
    public void setTitle(String title) {
        this.title = title;
    }
    public String getDescription() {
        return description;
    }
    public void setDescription(String desc) {
        this.description = desc;
    }
    public String getLink() {
        return link;
    }
    public void setLink(String link) {
        this.link = link;
    }

    public String validate(Map propMap) {
        boolean isBlankTitle = StringUtils.isBlank((String) propMap.get("title"));
        boolean isBlankURL = StringUtils.isBlank((String) propMap.get("link"));
        return isBlankTitle || isBlankURL ?
            "^CgURL͂Ă": null;
    }

    public String decorateLabelText(String propName) {
        if ("title".equals(propName)) {
            return "^Cg(&T):";
        } else if ("link".equals(propName)) {
            return "URL(&U):";
        } else if ("description".equals(propName)) {
            return "(&D):";
        }
        return null;
    }

    public int compare(String propName1, String propName2) {
        String[] index = {"title", "link", "description"};
        return SortUtil.compareWithIndex(propName1, propName2, index);
    }
}
