/*
 * Created on 2005/02/28
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.ui.dialogs;

import java.util.Map;

import org.apache.commons.lang.StringUtils;

import razgriz.news.ui.dialogs.BeanEditorDialog.PropertyValidator;
import razgriz.news.ui.dialogs.BeanEditorDialog.PropertyDecorator;

/**
 * 
 */
public class GroupDialogBean implements PropertyValidator, PropertyDecorator {
    private String title;
        
    public String getTitle() {
        return title;
    }
    public void setTitle(String title) {
        this.title = title;
    }

    public String validate(Map propMap) {
        return StringUtils.isBlank((String) propMap.get("title"))?
            "^Cg͂Ă": null;
    }
    public String decorateLabelText(String propName) {
        if ("title".equals(propName)) {
            return "^Cg(&T):";
        }
        return null;
    }
}
