/*
 * Created on 2005/02/20
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.ui.browser;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;


/**
 * 
 */
public class NewsBrowser extends EditorPart {
    public static final String ID = NewsBrowser.class.getName();

    Browser browser;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof NewsBrowserInput)) {
            throw new PartInitException("Input must be instance of NewsBrowserInput");
        }
        setInput(input);
        setSite(site);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public Browser getBrowser() {
        return browser;
    }

    public void createPartControl(Composite parent) {
        NewsBrowserInput input = (NewsBrowserInput) getEditorInput();

        Composite composite = new Composite(parent, SWT.NONE);
        GridLayout layout = new GridLayout();
        composite.setLayout(layout);
        layout.numColumns = 1;

        browser = new Browser(composite, SWT.NONE);
        browser.setLayoutData(new GridData(GridData.FILL_BOTH));

        browser.addTitleListener(new TitleListener(){
            public void changed(TitleEvent event) {
                setPartName(event.title);
            }
        });

        final IActionBars actionBars = getEditorSite().getActionBars();
        browser.addProgressListener(new ProgressAdapter() {
            IProgressMonitor monitor =
                actionBars.getStatusLineManager().getProgressMonitor();
            boolean working = false;
            int workedSoFar;
            public void changed(ProgressEvent event) {
                if (event.total == 0) return;
                if (!working) {
                    if (event.current == event.total) return;
                    monitor.beginTask("", event.total); //$NON-NLS-1$
                    workedSoFar = 0;
                    working = true;
                }
                monitor.worked(event.current - workedSoFar);
                workedSoFar = event.current;
            }
            public void completed(ProgressEvent event) {
                monitor.done();
                working = false;
            }
        });

        browser.addStatusTextListener(new StatusTextListener() {
            IStatusLineManager status = actionBars.getStatusLineManager(); 
            public void changed(StatusTextEvent event) {
                status.setMessage(event.text);
            }
        });
        
        if (!StringUtils.isEmpty(input.getUrl())) {
            browser.setUrl(input.getUrl());
        }
    }

    public void setFocus() {
        browser.setFocus();
    }

}
