/*
 * Created on 2005/01/25
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IWorkbenchSite;

import razgriz.news.model.Group;
import razgriz.news.ui.dialogs.BeanEditorDialog;
import razgriz.news.ui.dialogs.GroupDialogBean;

/**
 * 
 */
public class EditGroupAction extends Action {
    public static final String ID = EditGroupAction.class.getName();
    IWorkbenchSite site;
    TreeViewer viewer;

    public EditGroupAction(IWorkbenchSite site, TreeViewer viewer) {
        super();

        this.site = site;
        this.viewer = viewer;

        setId(ID);
        setText("O[v̕ҏW");
        setToolTipText("O[vҏW܂");
        setImageDescriptor(null);
    }

    public void run() {
        IStructuredSelection sel = (IStructuredSelection) viewer.getSelection();

        if (sel.size() != 1) {
            throw new IllegalArgumentException(); // todo:                    
        }

        Object obj = sel.getFirstElement();

        if (obj instanceof Group) {
            Group grp = (Group) obj;

            GroupDialogBean bean = new GroupDialogBean();
            bean.setTitle(grp.getTitle());

            BeanEditorDialog dialog = new BeanEditorDialog(
                site.getShell(),
                "O[v̕ҏW",
                "O[v̏͂Ă",
                bean,
                bean,
                bean,
                null
            );
            if (dialog.open() == BeanEditorDialog.OK) {
                grp.setTitle(bean.getTitle());
            }
        }
    }
}
