/**
 * <copyright>
 * </copyright>
 *
 * $Id: ArticleImpl.java,v 1.1 2005/02/26 07:18:17 mkamo Exp $
 */
package razgriz.news.model.impl;

import java.util.Date;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

import razgriz.news.model.Article;
import razgriz.news.model.News;
import razgriz.news.model.NewsPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Article</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link razgriz.news.model.impl.ArticleImpl#getTitle <em>Title</em>}</li>
 *   <li>{@link razgriz.news.model.impl.ArticleImpl#getLink <em>Link</em>}</li>
 *   <li>{@link razgriz.news.model.impl.ArticleImpl#getDescription <em>Description</em>}</li>
 *   <li>{@link razgriz.news.model.impl.ArticleImpl#getAuthor <em>Author</em>}</li>
 *   <li>{@link razgriz.news.model.impl.ArticleImpl#getDate <em>Date</em>}</li>
 *   <li>{@link razgriz.news.model.impl.ArticleImpl#isRead <em>Read</em>}</li>
 *   <li>{@link razgriz.news.model.impl.ArticleImpl#getNews <em>News</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ArticleImpl extends ModelElementImpl implements Article {
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public static final String copyright = "KAMO Masahiko";

    /**
     * The default value of the '{@link #getTitle() <em>Title</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getTitle()
     * @generated
     * @ordered
     */
    protected static final String TITLE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getTitle() <em>Title</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getTitle()
     * @generated
     * @ordered
     */
    protected String title = TITLE_EDEFAULT;

    /**
     * The default value of the '{@link #getLink() <em>Link</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getLink()
     * @generated
     * @ordered
     */
    protected static final String LINK_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getLink() <em>Link</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getLink()
     * @generated
     * @ordered
     */
    protected String link = LINK_EDEFAULT;

    /**
     * The default value of the '{@link #getDescription() <em>Description</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDescription()
     * @generated
     * @ordered
     */
    protected static final String DESCRIPTION_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getDescription() <em>Description</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDescription()
     * @generated
     * @ordered
     */
    protected String description = DESCRIPTION_EDEFAULT;

    /**
     * The default value of the '{@link #getAuthor() <em>Author</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getAuthor()
     * @generated
     * @ordered
     */
    protected static final String AUTHOR_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getAuthor() <em>Author</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getAuthor()
     * @generated
     * @ordered
     */
    protected String author = AUTHOR_EDEFAULT;

    /**
     * The default value of the '{@link #getDate() <em>Date</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDate()
     * @generated
     * @ordered
     */
    protected static final Date DATE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getDate() <em>Date</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDate()
     * @generated
     * @ordered
     */
    protected Date date = DATE_EDEFAULT;

    /**
     * The default value of the '{@link #isRead() <em>Read</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #isRead()
     * @generated
     * @ordered
     */
    protected static final boolean READ_EDEFAULT = false;

    /**
     * The cached value of the '{@link #isRead() <em>Read</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #isRead()
     * @generated
     * @ordered
     */
    protected boolean read = READ_EDEFAULT;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ArticleImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return NewsPackage.eINSTANCE.getArticle();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getTitle() {
        return title;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setTitle(String newTitle) {
        String oldTitle = title;
        title = newTitle;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, NewsPackage.ARTICLE__TITLE, oldTitle, title));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getLink() {
        return link;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setLink(String newLink) {
        String oldLink = link;
        link = newLink;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, NewsPackage.ARTICLE__LINK, oldLink, link));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getDescription() {
        return description;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setDescription(String newDescription) {
        String oldDescription = description;
        description = newDescription;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, NewsPackage.ARTICLE__DESCRIPTION, oldDescription, description));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getAuthor() {
        return author;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setAuthor(String newAuthor) {
        String oldAuthor = author;
        author = newAuthor;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, NewsPackage.ARTICLE__AUTHOR, oldAuthor, author));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Date getDate() {
        return date;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setDate(Date newDate) {
        Date oldDate = date;
        date = newDate;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, NewsPackage.ARTICLE__DATE, oldDate, date));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean isRead() {
        return read;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setRead(boolean newRead) {
        boolean oldRead = read;
        read = newRead;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, NewsPackage.ARTICLE__READ, oldRead, read));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public News getNews() {
        if (eContainerFeatureID != NewsPackage.ARTICLE__NEWS) return null;
        return (News)eContainer;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setNews(News newNews) {
        if (newNews != eContainer || (eContainerFeatureID != NewsPackage.ARTICLE__NEWS && newNews != null)) {
            if (EcoreUtil.isAncestor(this, (EObject)newNews))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eContainer != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newNews != null)
                msgs = ((InternalEObject)newNews).eInverseAdd(this, NewsPackage.NEWS__ARTICLES, News.class, msgs);
            msgs = eBasicSetContainer((InternalEObject)newNews, NewsPackage.ARTICLE__NEWS, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, NewsPackage.ARTICLE__NEWS, newNews, newNews));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case NewsPackage.ARTICLE__NEWS:
                    if (eContainer != null)
                        msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, NewsPackage.ARTICLE__NEWS, msgs);
                default:
                    return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
            }
        }
        if (eContainer != null)
            msgs = eBasicRemoveFromContainer(msgs);
        return eBasicSetContainer(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case NewsPackage.ARTICLE__NEWS:
                    return eBasicSetContainer(null, NewsPackage.ARTICLE__NEWS, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        if (eContainerFeatureID >= 0) {
            switch (eContainerFeatureID) {
                case NewsPackage.ARTICLE__NEWS:
                    return ((InternalEObject)eContainer).eInverseRemove(this, NewsPackage.NEWS__ARTICLES, News.class, msgs);
                default:
                    return eDynamicBasicRemoveFromContainer(msgs);
            }
        }
        return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case NewsPackage.ARTICLE__TITLE:
                return getTitle();
            case NewsPackage.ARTICLE__LINK:
                return getLink();
            case NewsPackage.ARTICLE__DESCRIPTION:
                return getDescription();
            case NewsPackage.ARTICLE__AUTHOR:
                return getAuthor();
            case NewsPackage.ARTICLE__DATE:
                return getDate();
            case NewsPackage.ARTICLE__READ:
                return isRead() ? Boolean.TRUE : Boolean.FALSE;
            case NewsPackage.ARTICLE__NEWS:
                return getNews();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case NewsPackage.ARTICLE__TITLE:
                setTitle((String)newValue);
                return;
            case NewsPackage.ARTICLE__LINK:
                setLink((String)newValue);
                return;
            case NewsPackage.ARTICLE__DESCRIPTION:
                setDescription((String)newValue);
                return;
            case NewsPackage.ARTICLE__AUTHOR:
                setAuthor((String)newValue);
                return;
            case NewsPackage.ARTICLE__DATE:
                setDate((Date)newValue);
                return;
            case NewsPackage.ARTICLE__READ:
                setRead(((Boolean)newValue).booleanValue());
                return;
            case NewsPackage.ARTICLE__NEWS:
                setNews((News)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case NewsPackage.ARTICLE__TITLE:
                setTitle(TITLE_EDEFAULT);
                return;
            case NewsPackage.ARTICLE__LINK:
                setLink(LINK_EDEFAULT);
                return;
            case NewsPackage.ARTICLE__DESCRIPTION:
                setDescription(DESCRIPTION_EDEFAULT);
                return;
            case NewsPackage.ARTICLE__AUTHOR:
                setAuthor(AUTHOR_EDEFAULT);
                return;
            case NewsPackage.ARTICLE__DATE:
                setDate(DATE_EDEFAULT);
                return;
            case NewsPackage.ARTICLE__READ:
                setRead(READ_EDEFAULT);
                return;
            case NewsPackage.ARTICLE__NEWS:
                setNews((News)null);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case NewsPackage.ARTICLE__TITLE:
                return TITLE_EDEFAULT == null ? title != null : !TITLE_EDEFAULT.equals(title);
            case NewsPackage.ARTICLE__LINK:
                return LINK_EDEFAULT == null ? link != null : !LINK_EDEFAULT.equals(link);
            case NewsPackage.ARTICLE__DESCRIPTION:
                return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
            case NewsPackage.ARTICLE__AUTHOR:
                return AUTHOR_EDEFAULT == null ? author != null : !AUTHOR_EDEFAULT.equals(author);
            case NewsPackage.ARTICLE__DATE:
                return DATE_EDEFAULT == null ? date != null : !DATE_EDEFAULT.equals(date);
            case NewsPackage.ARTICLE__READ:
                return read != READ_EDEFAULT;
            case NewsPackage.ARTICLE__NEWS:
                return getNews() != null;
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (title: ");
        result.append(title);
        result.append(", link: ");
        result.append(link);
        result.append(", description: ");
        result.append(description);
        result.append(", author: ");
        result.append(author);
        result.append(", date: ");
        result.append(date);
        result.append(", read: ");
        result.append(read);
        result.append(')');
        return result.toString();
    }

} //ArticleImpl
