/*
 * Created on 2005/03/03
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.visitor;

import razgriz.news.model.Article;
import razgriz.news.model.ModelElement;
import razgriz.news.model.util.ModelVisitor;

/**
 * 
 */
public class UnreadArticleCountingVisitor extends ModelVisitor {
    private int count;

    public UnreadArticleCountingVisitor() {
        super();
        count = 0;
    }

    public Object caseArticle(Article article) {
        if (!article.isRead()) {
            count++;
        }
        return article;
    }

    public boolean prune(ModelElement elem) {
        return false;
    }

    public int getResult() {
        return count;
    }
}
