/*
 * Created on 2005/03/03
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.visitor;

import java.util.ArrayList;
import java.util.List;

import razgriz.news.model.Article;
import razgriz.news.model.ModelElement;
import razgriz.news.model.util.ModelVisitor;

/**
 * 
 */
public class UnreadArticleCollectingVisitor extends ModelVisitor {
    private List unreadArticleList;

    public UnreadArticleCollectingVisitor() {
        super();
        unreadArticleList = new ArrayList();
    }

    public Object caseArticle(Article article) {
        if (!article.isRead()) {
            unreadArticleList.add(article);
        }
        return article;
    }

    public boolean prune(ModelElement elem) {
        return false;
    }

    public Article[] getResult() {
        return (Article[]) unreadArticleList.toArray(
            new Article[unreadArticleList.size()]
        );
    }
}
