/*
 * Created on 2005/01/22
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.favlist;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

import razgriz.news.NewsException;
import razgriz.news.model.FavoriteList;
import razgriz.news.model.NewsFactory;

/**
 * 
 */
public class FavoriteListService {
    private static final String SUFFIX = ".news";

    private Map nameToListMap; // Map<String, FavoriteList>
    
    public FavoriteListService() {
        nameToListMap = new HashMap();
    }

    protected IPath getFilePath(String listname) {
        IPath rootpath = Platform.getLocation();
        IPath filepath = rootpath.append(listname + SUFFIX);
        return filepath;
    }

    public FavoriteList create(String listname) {
        IPath filepath = getFilePath(listname);
        File file = filepath.toFile();

        if (!file.exists()) {
            URI uri = URI.createFileURI(file.getAbsolutePath());
            Resource res = new ResourceSetImpl().createResource(uri);

            NewsFactory fact = NewsFactory.eINSTANCE;
            FavoriteList flist = fact.createFavoriteList();
            nameToListMap.put(listname, flist);
                
            res.getContents().add(flist);
            return flist;
        } else {
            throw new NewsException("Failed to create favorite list");
        }
    }

    public FavoriteList load(String listname) {
        return load(listname, true);
    }

    public FavoriteList load(String listname, boolean create) {
        IPath filepath = getFilePath(listname);
        File file = filepath.toFile();

        try {
            if (file.exists()) {
                URI uri = URI.createFileURI(file.getAbsolutePath());
                Resource res = new ResourceSetImpl().getResource(uri, true);
                res.load(null);
                FavoriteList ret = (FavoriteList) res.getContents().get(0);
                nameToListMap.put(listname, ret);
                return ret;
            } else {
                if (create) {
                    return create(listname);
                } else {
                    throw new NewsException("Failed to load favorite list"); // todo:
                }
            }
        } catch (IOException e) {
            throw new NewsException(e); // todo:
        }
    }

    public void save(String listname) {
        FavoriteList list = (FavoriteList) nameToListMap.get(listname);
        if (list == null) {
            throw new NewsException("Favorite list not found(listname=" + listname + ")");
        }
        
        IPath filepath = getFilePath(listname);
        URI uri = URI.createFileURI(filepath.toFile().getAbsolutePath());

        try {
            Resource res = new ResourceSetImpl().createResource(uri);

            res.getContents().clear();
            res.getContents().add(list);
            res.save(null);
        } catch (IOException e) {
            throw new NewsException(e); // todo:
        }
        
    }
}
