/*
 * Created on 2005/01/21
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.model.rss10.clipper;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

import razgriz.common.text.XMLFirstElementPicker;
import razgriz.common.text.XMLFirstElementPicker.XMLElement;
import razgriz.news.clipper.NewsClipper;
import razgriz.news.model.Article;
import razgriz.news.model.News;
import razgriz.news.model.NewsFactory;
import razgriz.news.model.rss10.Channel;
import razgriz.news.model.rss10.Item;
import razgriz.news.model.rss10.RDF;
import razgriz.news.model.rss10.util.DefaultRSS10ResourceFactoryImpl;

/**
 * 
 */
public class RSS10NewsClipper implements NewsClipper {

    public RSS10NewsClipper() {
    }

    public boolean canClip(InputStream in) {
        XMLFirstElementPicker picker = new XMLFirstElementPicker();
        XMLElement elem = picker.pick(in);
        return "rdf:RDF".equals(elem.getQName());
    }

    public News clip(InputStream in) {
        URI uri = URI.createURI("razgriz://stream");

        try {
            Resource res =
                new DefaultRSS10ResourceFactoryImpl().createResource(uri);

            res.load(in, null);
            if (res.getContents().isEmpty()) {
                throw new IllegalArgumentException(
                    "Document root element not found"
                );
            }
            RDF rdf = (RDF) res.getContents().get(0);

            return convert(rdf);
        } catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage()); // todo:
        }

    }

    public News convert(RDF rdf) {
        NewsFactory fact = NewsFactory.eINSTANCE;

        List ret = new ArrayList();
        Channel ch = rdf.getChannel();
        
        News news = fact.createNews();

        news.setDate(ch.getDcDate());
        news.setDescription(ch.getDescription());
        news.setLink(ch.getLink());
        news.setTitle(ch.getTitle());

        List items = rdf.getItem();
        for (int i = 0, len = items.size(); i < len; i++) {
            Item item = (Item) items.get(i);
            Article article = fact.createArticle();

            article.setAuthor(item.getDcCreator());
            article.setDescription(item.getDescription());
            article.setLink(item.getLink());

            Date date = item.getDcDate();
            date = date == null? new Date(): date;
            article.setDate(date);

            article.setTitle(item.getTitle());
            article.setRead(false);

            news.getArticles().add(article);
        }
            
        return news;
    }
}
