/*
 * Created on 2005/01/28
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.app;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;

import razgriz.news.ui.perspectives.NewsPerspective;

/**
 * 
 */
public class RazgrizWorkbenchAdvisor extends WorkbenchAdvisor {

    public RazgrizWorkbenchAdvisor() {
        super();
    }

    public String getInitialWindowPerspectiveId() {
        return NewsPerspective.ID;
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        configurer.setSaveAndRestore(true);
    }

    public void preWindowOpen(IWorkbenchWindowConfigurer configurer) {
        super.preWindowOpen(configurer);

        configurer.setTitle("Razgriz");

        configurer.setShowCoolBar(true);
        configurer.setShowFastViewBars(true);
        configurer.setShowMenuBar(true);
        configurer.setShowPerspectiveBar(false);
        configurer.setShowProgressIndicator(true);
        configurer.setShowStatusLine(true);
    }

    public void fillActionBars(
        IWorkbenchWindow window, IActionBarConfigurer configurer, int flags
    ) {
        super.fillActionBars(window, configurer, flags);
         if ((flags & FILL_MENU_BAR) != 0) {
            fillMenuBar(window, configurer);
        }
    }

    private void fillMenuBar(
        IWorkbenchWindow window,IActionBarConfigurer configurer
    ) {
        IMenuManager menuBar = configurer.getMenuManager();
        menuBar.add(createFileMenu(window));
        menuBar.add(createWindowMenu(window));
//        menuBar.add(createEditMenu(window));
        menuBar.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));
        menuBar.add(createHelpMenu(window));
    }


    private MenuManager createFileMenu(IWorkbenchWindow window) {
        MenuManager menu = new MenuManager(
            "t@C(&F)", IWorkbenchActionConstants.M_FILE
        );
        menu.add(new GroupMarker(IWorkbenchActionConstants.FILE_START));
        menu.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));
        menu.add(ActionFactory.QUIT.create(window));
        menu.add(new GroupMarker(IWorkbenchActionConstants.FILE_END));
        return menu;
    }

    private MenuManager createWindowMenu(IWorkbenchWindow window) {
        MenuManager menu = new MenuManager(
            "EBhE(&W)", IWorkbenchActionConstants.M_WINDOW
        );

        MenuManager viewMenu = new MenuManager("r[̕\(&V)");
        IContributionItem viewList = 
            ContributionItemFactory.VIEWS_SHORTLIST.create(window);
        viewMenu.add(viewList);
        menu.add(viewMenu);
        menu.add(new Separator(IWorkbenchActionConstants.MB_ADDITIONS));
        menu.add(ActionFactory.PREFERENCES.create(window));

        return menu;
    }

    private MenuManager createHelpMenu(IWorkbenchWindow window) {
        MenuManager menu = new MenuManager(
            "wv(&H)", IWorkbenchActionConstants.M_HELP
        );
        menu.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));
        menu.add(ActionFactory.ABOUT.create(window));

        return menu;
    }
}
