/*
 * Decompiled with CFR 0.152.
 */
package razgriz.news.ui.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchSite;
import razgriz.news.model.Favorite;
import razgriz.news.model.Group;
import razgriz.news.model.News;
import razgriz.news.model.opml.Body;
import razgriz.news.model.opml.Head;
import razgriz.news.model.opml.OPML;
import razgriz.news.model.opml.OPMLFactory;
import razgriz.news.model.opml.Outline;
import razgriz.news.ui.NewsUIPlugin;

public class ExportOPMLAction
extends Action {
    public static final String ID;
    IWorkbenchSite site;
    TreeViewer viewer;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("razgriz.news.ui.actions.ExportOPMLAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID = clazz.getName();
    }

    public ExportOPMLAction(IWorkbenchSite site, TreeViewer viewer) {
        this.site = site;
        this.viewer = viewer;
        this.setId(ID);
        this.setText("OPML\u30a8\u30af\u30b9\u30dd\u30fc\u30c8");
        this.setToolTipText("OPML\u3092\u304a\u6c17\u306b\u5165\u308a\u304b\u3089\u30a8\u30af\u30b9\u30dd\u30fc\u30c8\u3057\u307e\u3059");
        this.setImageDescriptor(null);
    }

    public void run() {
        FileDialog dialog = new FileDialog(this.site.getShell(), 8192);
        String result = dialog.open();
        if (result != null) {
            URI uri = URI.createFileURI((String)result);
            Resource res = new ResourceSetImpl().createResource(uri);
            OPMLFactory fact = OPMLFactory.eINSTANCE;
            OPML opml = fact.createOPML();
            opml.setVersion("1.0");
            Body body = fact.createBody();
            opml.setBody(body);
            List favlist = NewsUIPlugin.getFavoriteList().getFavorites();
            ArrayList<Outline> ollist = new ArrayList<Outline>();
            int i = 0;
            while (i < favlist.size()) {
                ollist.add(this.convert((Favorite)favlist.get(i)));
                ++i;
            }
            body.getOutline().addAll(ollist);
            Head head = fact.createHead();
            head.setTitle("Razgriz Favorite List");
            head.setDateCreated(new Date().toString());
            opml.setHead(head);
            try {
                res.getContents().add((Object)opml);
                res.save(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    public Outline convert(Favorite favorite) {
        OPMLFactory fact = OPMLFactory.eINSTANCE;
        Outline ret = fact.createOutline();
        if (favorite instanceof News) {
            News news = (News)favorite;
            ret.setType("rss");
            ret.setText(news.getTitle());
            ret.setTitle(news.getTitle());
            ret.setXmlUrl(news.getLink());
            ret.setDescription(StringUtils.defaultString((String)news.getDescription()));
        } else if (favorite instanceof Group) {
            Group grp = (Group)favorite;
            ret.setText(grp.getTitle());
            ret.setTitle(grp.getTitle());
            List members = grp.getMembers();
            ArrayList<Outline> ollist = new ArrayList<Outline>();
            int i = 0;
            while (i < members.size()) {
                ollist.add(this.convert((Favorite)members.get(i)));
                ++i;
            }
            ret.getOutline().addAll(ollist);
        }
        return ret;
    }
}

