/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.internal.ActionDescriptor;
import org.eclipse.ui.internal.FastViewBar;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.KeyBindingService;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.PluginAction;
import org.eclipse.ui.internal.RectangleAnimation;
import org.eclipse.ui.internal.ViewActionBuilder;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.ViewStack;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.part.ViewPart;

public class ViewPane
extends PartPane
implements IPropertyListener {
    private boolean busy = false;
    private boolean fast = false;
    private boolean showFocus = false;
    private boolean locked = true;
    ToolBar isvToolBar;
    private ToolBarManager isvToolBarMgr = new PaneToolBarManager(0x800040);
    private MenuManager isvMenuMgr;
    boolean hasFocus;
    private boolean hadViewMenu = false;

    public ViewPane(IViewReference ref, WorkbenchPage page) {
        super(ref, page);
        this.fast = ref.isFastView();
    }

    public void createControl(Composite parent) {
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            return;
        }
        super.createControl(parent);
    }

    protected void createChildControl() {
        IWorkbenchPart[] part = new IWorkbenchPart[]{this.partReference.getPart(false)};
        if (part[0] == null) {
            return;
        }
        if (this.control == null) {
            return;
        }
        if (this.control.getChildren().length != 0) {
            return;
        }
        super.createChildControl();
        Platform.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                ViewActionBuilder builder = new ViewActionBuilder();
                IViewPart part = (IViewPart)ViewPane.this.getViewReference().getPart(true);
                if (part != null) {
                    builder.readActionExtensions(part);
                    ActionDescriptor[] actionDescriptors = builder.getExtendedActions();
                    KeyBindingService keyBindingService = (KeyBindingService)part.getSite().getKeyBindingService();
                    if (actionDescriptors != null) {
                        int i = 0;
                        while (i < actionDescriptors.length) {
                            PluginAction action;
                            ActionDescriptor actionDescriptor = actionDescriptors[i];
                            if (actionDescriptor != null && (action = actionDescriptors[i].getAction()) != null && action.getActionDefinitionId() != null) {
                                keyBindingService.registerAction((IAction)action);
                            }
                            ++i;
                        }
                    }
                }
                ViewPane.this.updateActionBars();
            }

            public void handleException(Throwable e) {
            }
        });
    }

    private void recreateToolbars() {
        this.createToolBars();
        this.updateActionBars();
    }

    protected IWorkbenchPart createErrorPart(IWorkbenchPart oldPart) {
        class ErrorViewPart
        extends ViewPart {
            private Text text;
            final /* synthetic */ ViewPane this$0;

            ErrorViewPart(ViewPane viewPane) {
                this.this$0 = viewPane;
            }

            public void createPartControl(Composite parent) {
                this.text = new Text(parent, 74);
                this.text.setForeground(JFaceColors.getErrorText((Display)this.text.getDisplay()));
                this.text.setBackground(this.text.getDisplay().getSystemColor(22));
                this.text.setText(WorkbenchMessages.getString("ViewPane.errorMessage"));
            }

            public void setFocus() {
                if (this.text != null) {
                    this.text.setFocus();
                }
            }

            public void setSite(IWorkbenchPartSite site) {
                super.setSite(site);
            }

            public void setPartName(String title) {
                super.setPartName(title);
            }
        }
        ErrorViewPart newPart = new ErrorViewPart(this);
        PartSite site = (PartSite)oldPart.getSite();
        newPart.setSite(site);
        newPart.setPartName(site.getRegisteredName());
        site.setPart(newPart);
        return newPart;
    }

    protected void createTitleBar() {
        this.updateTitles();
        this.getPartReference().addPropertyListener(this);
        this.createToolBars();
    }

    private void toolBarResized(ToolBar toolBar, int newSize) {
        if (this.isvToolBar != null) {
            Control ctrl = this.getControl();
            boolean visible = ctrl != null && ctrl.isVisible() && this.toolbarIsVisible();
            this.isvToolBar.setVisible(visible);
        }
        this.presentableAdapter.firePropertyChange(147);
    }

    private void createToolBars() {
        Composite parentControl = this.control;
        this.isvToolBar = this.isvToolBarMgr.createControl(parentControl.getParent());
        if (this.locked) {
            this.isvToolBar.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent event) {
                    if (ViewPane.this.isvToolBar.getItem(new Point(event.x, event.y)) == null) {
                        ViewPane.this.doZoom();
                    }
                }
            });
        }
        this.isvToolBar.addListener(26, (Listener)this);
    }

    public void dispose() {
        super.dispose();
        if (this.isvMenuMgr != null) {
            this.isvMenuMgr.dispose();
        }
        if (this.isvToolBarMgr != null) {
            this.isvToolBarMgr.dispose();
        }
    }

    public void doHide() {
        this.getPage().hideView(this.getViewReference());
    }

    private Rectangle getParentBounds() {
        LayoutPart part;
        Control ctrl = this.getControl();
        if (this.getContainer() != null && this.getContainer() instanceof LayoutPart && (part = (LayoutPart)((Object)this.getContainer())).getControl() != null) {
            ctrl = part.getControl();
        }
        return DragUtil.getDisplayBounds(ctrl);
    }

    public void doMakeFast() {
        WorkbenchWindow window = (WorkbenchWindow)this.getPage().getWorkbenchWindow();
        FastViewBar fastViewBar = window.getFastViewBar();
        if (fastViewBar == null) {
            return;
        }
        Shell shell = window.getShell();
        RectangleAnimation animation = new RectangleAnimation(shell, this.getParentBounds(), fastViewBar.getLocationOfNextIcon());
        animation.schedule();
        this.getPage().addFastView(this.getViewReference());
    }

    public void doRemoveFast() {
        Shell shell = this.getControl().getShell();
        Rectangle initialBounds = this.getParentBounds();
        this.getPage().removeFastView(this.getViewReference());
        Rectangle finalBounds = this.getParentBounds();
        RectangleAnimation animation = new RectangleAnimation(shell, initialBounds, finalBounds);
        animation.schedule();
    }

    protected void doDock() {
        this.getPage().removeFastView(this.getViewReference());
    }

    public String getCompoundId() {
        IViewReference ref = this.getViewReference();
        if (ref != null) {
            return ViewFactory.getKey(ref);
        }
        return super.getCompoundId();
    }

    public Control getDragHandle() {
        return this.control;
    }

    public MenuManager getMenuManager() {
        if (this.isvMenuMgr == null) {
            this.isvMenuMgr = new PaneMenuManager();
        }
        return this.isvMenuMgr;
    }

    public Control[] getTabList() {
        Control c = this.getControl();
        if (this.getContainer() instanceof ViewStack) {
            ViewStack tf = (ViewStack)this.getContainer();
            return tf.getTabList(this);
        }
        return new Control[]{c};
    }

    public ToolBarManager getToolBarManager() {
        return this.isvToolBarMgr;
    }

    public IViewReference getViewReference() {
        return (IViewReference)this.getPartReference();
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 1) {
            this.updateTitles();
        }
    }

    public void setFast(boolean b) {
        this.fast = b;
    }

    void shellActivated() {
    }

    void shellDeactivated() {
    }

    void setActive(boolean active) {
        this.hasFocus = active;
        if (this.getContainer() instanceof PartStack) {
            ((PartStack)this.getContainer()).setActive(active ? 1 : 0);
        }
    }

    public void showFocus(boolean inFocus) {
        this.setActive(inFocus);
    }

    private boolean isFastView() {
        return this.page.isFastView(this.getViewReference());
    }

    boolean isMoveable() {
        return !this.page.isFixedLayout();
    }

    public boolean hasViewMenu() {
        if (this.isvMenuMgr != null) {
            return !this.isvMenuMgr.isEmpty();
        }
        return false;
    }

    public void showViewMenu(Point location) {
        if (!this.hasViewMenu()) {
            return;
        }
        if (this.isFastView() && this.page.getActiveFastView() != this.getViewReference()) {
            return;
        }
        Menu aMenu = this.isvMenuMgr.createContextMenu((Control)this.getControl().getParent());
        aMenu.setLocation(location.x, location.y);
        aMenu.setVisible(true);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "@" + Integer.toHexString(this.hashCode());
    }

    public void updateActionBars() {
        if (this.isvMenuMgr != null) {
            this.isvMenuMgr.updateAll(false);
        }
        if (this.isvToolBarMgr != null) {
            this.isvToolBarMgr.update(false);
        }
    }

    public void updateTitles() {
        this.presentableAdapter.firePropertyChange(1);
    }

    public void addSizeMenuItem(Menu menu, int index) {
        if (this.isMoveable()) {
            super.addSizeMenuItem(menu, index);
        }
    }

    protected void doZoom() {
        if (this.isMoveable()) {
            super.doZoom();
        }
    }

    public void setContainer(ILayoutContainer container) {
        ILayoutContainer oldContainer = this.getContainer();
        if (this.hasFocus) {
            if (oldContainer != null && oldContainer instanceof PartStack) {
                ((PartStack)oldContainer).setActive(0);
            }
            if (container != null && container instanceof PartStack) {
                ((PartStack)container).setActive(1);
            }
        }
        super.setContainer(container);
    }

    public void reparent(Composite newParent) {
        super.reparent(newParent);
        if (this.isvToolBar != null) {
            this.isvToolBar.setParent(newParent);
        }
    }

    public void moveAbove(Control refControl) {
        super.moveAbove(refControl);
        this.isvToolBar.moveAbove((Control)this.control);
    }

    public void setVisible(boolean makeVisible) {
        super.setVisible(makeVisible);
        if (this.isvToolBar != null) {
            this.isvToolBar.setVisible(makeVisible && this.toolbarIsVisible());
        }
    }

    public boolean toolbarIsVisible() {
        ToolBarManager toolbarManager = this.getToolBarManager();
        if (toolbarManager == null) {
            return false;
        }
        ToolBar control = toolbarManager.getControl();
        if (control == null || control.isDisposed()) {
            return false;
        }
        return control.getItemCount() > 0;
    }

    public void setBusy(boolean isBusy) {
        if (isBusy != this.busy) {
            this.busy = isBusy;
            this.presentableAdapter.firePropertyChange(146);
        }
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void showHighlight() {
        this.presentableAdapter.firePropertyChange(148);
    }

    public String getPlaceHolderId() {
        return ViewFactory.getKey(this.getViewReference());
    }

    public Control getToolBar() {
        if (!this.toolbarIsVisible()) {
            return null;
        }
        ToolBarManager toolbarManager = this.getToolBarManager();
        if (toolbarManager == null) {
            return null;
        }
        ToolBar control = toolbarManager.getControl();
        if (control == null || control.isDisposed()) {
            return null;
        }
        return control;
    }

    class PaneToolBarManager
    extends ToolBarManager {
        public PaneToolBarManager(int style) {
            super(style);
        }

        protected void relayout(ToolBar toolBar, int oldCount, int newCount) {
            ViewPane.this.toolBarResized(toolBar, newCount);
            toolBar.layout();
        }
    }

    class PaneMenuManager
    extends MenuManager {
        public PaneMenuManager() {
            super("View Local Menu");
        }

        protected void update(boolean force, boolean recursive) {
            boolean hasMenu;
            super.update(force, recursive);
            boolean bl = hasMenu = !this.isEmpty();
            if (hasMenu != ViewPane.this.hadViewMenu) {
                ViewPane.this.hadViewMenu = hasMenu;
                ViewPane.this.presentableAdapter.firePropertyChange(770);
            }
        }
    }
}

